---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("ClassColors", {
	 ["WARRIOR"]	= { r = 0.78; g = 0.61; b = 0.43; a = 1.0 },
	 ["PALADIN"]	= { r = 0.96; g = 0.55; b = 0.73; a = 1.0 },
	 ["MAGE"]		= { r = 0.41; g = 0.8; b = 0.94; a = 1.0 },
	 ["DRUID"]		= { r = 1.0; g = 0.49; b = 0.04; a = 1.0 },
	 ["PSIONIC"]	= { r = 1.0; g = 0.96; b = 0.41; a = 1.0 },
	 ["STALKER"]	= { r = 0.67; g = 0.83; b = 0.45; a = 1.0 },
	 ["PRIEST"]		= { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["NECROMANCER"]= { r = 0.58; g = 0.51; b = 0.79; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("DamageTypeColors", {
	 ["ENUM_SubElement_PHYSICAL"]	= { r = 0.6; g = 0.4; b = 0.2; a = 1.0 },
	 ["ENUM_SubElement_FIRE"]		= { r = 1.0; g = 0.0; b = 0.0; a = 1.0 },
	 ["ENUM_SubElement_COLD"]		= { r = 0.5; g = 0.5; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_LIGHTNING"]	= { r = 0.8; g = 0.8; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_HOLY"]		= { r = 1.0; g = 1.0; b = 0.5; a = 1.0 },
	 ["ENUM_SubElement_SHADOW"]		= { r = 0.5; g = 0.1; b = 0.7; a = 1.0 },
	 ["ENUM_SubElement_ASTRAL"]		= { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_POISON"]		= { r = 0.5; g = 1.0; b = 0.5; a = 1.0 },
	 ["ENUM_SubElement_DISEASE"]	= { r = 0.7; g = 0.7; b = 0.4; a = 1.0 },
	 ["ENUM_SubElement_ACID"]		= { r = 1.0; g = 1.0; b = 0.0; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("HitTypeColors", {
	 ["HIT"]   = { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["CRIT"]  = { r = 1.0; g = 0.0; b = 0.0; a = 1.0 },
	 ["MISS"]  = { r = 1.0; g = 0.96; b = 0.41; a = 1.0 },
	 ["DODGE"] = { r = 0.0; g = 0.0; b = 1.0; a = 1.0 },
	 ["GLANCING"] = { r = 0.5; g = 1.0; b = 0.5; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------       -----------------------------------
---------------------------------------------------------------------------------------------------------------------------
-- Hack for AO 1.1.00 / 1.1.01 by SLA
if common.GetGlobalConfigSection then
	if not avatar.GetEmotes then Global( "userMods", {} ) end
	userMods.GetGlobalConfigSection = common.GetGlobalConfigSection
	userMods.SetGlobalConfigSection = common.SetGlobalConfigSection
end
---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------  "" -------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function CloneTable( value )
	if type( value ) == "table" then
		local new = {}
		for id, val in value do
			new[ id ] = CloneTable( val )
		end
		return new
	else
		return value
	end
end
function PrintData( data, tabstep )
	local TabString = ""
	
	if tabstep then 
		for i = 1, tabstep do
			TabString = TabString .. "	"
		end
	else
		tabstep = 0
	end
	
	for i, dataValue in data do
		if type( dataValue ) == "table" then
			LogInfo( TabString, i, ":" )
			PrintData( dataValue, tabstep + 1 )
		else
			LogInfo( TabString, i, " = ", dataValue ) 
		end
	end 
end
function RegisterEventHandlers( handlers )
	for event, handler in handlers do
		common.RegisterEventHandler( handler, event )
	end
end
function RegisterReactionHandlers( handlers )
	for event, handler in handlers do
		common.RegisterReactionHandler( handler, event )
	end
end
---------------------------------------------------------------------------------------------------------------------------
-- Localization selection by SLA. Version 2010-07-13. MODIFIED.
function SelectBestLocalization( tabValidLocalizations, strDefaultLocalization )
	local localization = strDefaultLocalization
	local MB = cartographer.GetMapBlocks()
	local MBI = cartographer.GetMapBlockInfo( MB[5] )
	if not MBI then return localization end
	if     common.CompareWString( MBI.name, common.GetAddonRelatedText( "localization_rus" ) ) == 0 then localization = "rus"
	elseif common.CompareWString( MBI.name, common.GetAddonRelatedText( "localization_eng" ) ) == 0 then localization = "eng"
	elseif common.CompareWString( MBI.name, common.GetAddonRelatedText( "localization_ger" ) ) == 0 then localization = "ger"
	elseif common.CompareWString( MBI.name, common.GetAddonRelatedText( "localization_fra" ) ) == 0 then localization = "fra"
	end
	local fLocalizationExists = false
	for _,l in pairs( tabValidLocalizations ) do
		if l == localization then fLocalizationExists = true end
	end
	if not fLocalizationExists then
		localization = strDefaultLocalization
	end
	return localization
end
-- Helper function to get localized strings.
function GetTextLocalized( strTextName )
	return common.GetAddonRelatedText( localization .. "_" .. strTextName )
end
---------------------------------------------------------------------------------------------------------------------------
function DNDInit()
	Global( "DragNDropWidgetList", {} )
	Global( "ScreenInfo", {} )
	ScreenInfo = widgetsSystem:GetPosConverterParams()
	common.RegisterEventHandler( OnEventDNDPickAttempt, "EVENT_DND_PICK_ATTEMPT" )
	common.RegisterEventHandler( OnEventDNDDragTo, "EVENT_DND_DRAG_TO" )
	common.RegisterEventHandler( OnEventDNDDropAttempt, "EVENT_DND_DROP_ATTEMPT" )
end
function DNDReg( wtWidget, wtID )
	if DragNDropWidgetList[ wtID ] == nil then 
		local NewDNDWidgetInfo = {
			Widget = wtWidget,
			ID = wtID,
			IsPicked = false
		}
		local SectionName = common.GetAddonName() .. "_Widget_" .. tostring(NewDNDWidgetInfo.ID)
		local CfgPlacement = userMods.GetGlobalConfigSection( SectionName )
		if CfgPlacement and CfgPlacement.x and CfgPlacement.y then
			local NewPlacement = NewDNDWidgetInfo.Widget:GetPlacementPlain()
			
			local Screen = widgetsSystem:GetPosConverterParams()
			if (CfgPlacement.x < 0) then CfgPlacement.x = 0 end
			if (CfgPlacement.x + NewPlacement.sizeX > Screen.fullVirtualSizeX) then CfgPlacement.x = math.floor( Screen.fullVirtualSizeX - NewPlacement.sizeX ) end
			if (CfgPlacement.y < 0) then CfgPlacement.y = 0 end
			if (CfgPlacement.y + NewPlacement.sizeY > Screen.fullVirtualSizeY) then CfgPlacement.y = math.floor( Screen.fullVirtualSizeY - NewPlacement.sizeY ) end
			
			NewPlacement.posX = CfgPlacement.x
			NewPlacement.posY = CfgPlacement.y
			NewDNDWidgetInfo.Widget:SetPlacementPlain( NewPlacement )
		end
		
		DragNDropWidgetList[ wtID ] = {}
		DragNDropWidgetList[ wtID ] = NewDNDWidgetInfo
	end
	mission.DNDRegister( wtWidget, DND_WIDGET_MOVE * DND_CONTAINER_STEP + wtID, true )
end
function DNDUnreg( wtWidget, ID )
	mission.DNDUnregister( wtWidget )
end
function OnEventDNDPickAttempt( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if math.mod( params.srcId, DND_CONTAINER_STEP ) == NewDNDWidgetInfo.ID then
			NewDNDWidgetInfo.Place = NewDNDWidgetInfo.Widget:GetPlacementPlain()
			ScreenInfo = widgetsSystem:GetPosConverterParams()
			NewDNDWidgetInfo.DeltaX = math.ceil( params.posX * ScreenInfo.fullVirtualSizeX / ScreenInfo.realSizeX - NewDNDWidgetInfo.Place.posX )
			NewDNDWidgetInfo.DeltaY = math.ceil( params.posY * ScreenInfo.fullVirtualSizeY / ScreenInfo.realSizeY - NewDNDWidgetInfo.Place.posY )
			common.SetCursor( "drag" )
			NewDNDWidgetInfo.IsPicked = true
		end
	end
end
function OnEventDNDDragTo( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if NewDNDWidgetInfo.IsPicked then
			NewDNDWidgetInfo.Place.posX = math.ceil( params.posX * ScreenInfo.fullVirtualSizeX / ScreenInfo.realSizeX - NewDNDWidgetInfo.DeltaX )
			NewDNDWidgetInfo.Place.posY = math.ceil( params.posY * ScreenInfo.fullVirtualSizeY / ScreenInfo.realSizeY - NewDNDWidgetInfo.DeltaY )
			NewDNDWidgetInfo.Widget:SetPlacementPlain( NewDNDWidgetInfo.Place )
			common.SetCursor( "drag" )
		end
	end
end
function OnEventDNDDropAttempt( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if NewDNDWidgetInfo.IsPicked then
			mission.DNDConfirmDropAttempt()
			common.SetCursor( "default" )
			NewDNDWidgetInfo.IsPicked = false
			local SectionName = common.GetAddonName() .. "_Widget_" .. tostring( NewDNDWidgetInfo.ID )
			userMods.SetGlobalConfigSection( SectionName, { x = NewDNDWidgetInfo.Place.posX, y = NewDNDWidgetInfo.Place.posY } )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------   ,  --------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TWidget", {} )
---------------------------------------------------------------------------------------------------------------------------
function TWidget:CreateNewObject( WidgetName )

	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	NewObject.Widget = nil
	NewObject.bMovable = false
	NewObject.DNDID = -1
	
	if WidgetName then
		NewObject.Widget = mainForm:GetChildUnchecked( WidgetName, true )
	end
	
	return NewObject
end
function TWidget:CreateNewObjectByDesc( WidgetName, Desc, Parent )

	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	NewObject.Widget = nil

	NewObject.Widget = mainForm:CreateWidgetByDesc( Desc )
	NewObject.Widget:SetName( WidgetName )

	if Parent then
		Parent.Widget:AddChild( NewObject.Widget )
	end

	return NewObject
end
function TWidget:GetDesc()
	if self.Widget then 
		local wtDesc = self.Widget:GetWidgetDesc()
		return wtDesc
	end
	return nil
end
function TWidget:GetChildCount()
	if self.Widget then 
		local Childrens = self.Widget:GetNamedChildren()
		return  GetTableSize( Childrens )
	end
	return 0
end
function TWidget:GetChildByName( Name )
	if self.Widget then 
		local Childrens = self.Widget:GetNamedChildren()
		if  ( GetTableSize( Childrens ) > 0 ) then
			for i = 0, GetTableSize( Childrens ) - 1 do
				local wtChild = Childrens[i]
				local ChildName = wtChild:GetName()
				if ( ChildName == Name ) then
					local NewObject = {}
					setmetatable( NewObject, {__index = self})
					NewObject.Widget = wtChild
					return NewObject
				end
			end
		end	
	end
	return nil
end
function TWidget:GetChildByIndex( ChildIndex )
	if self.Widget then
		local Childrens = self.Widget:GetNamedChildren()
		if  ( GetTableSize( Childrens ) > 0 ) then
			local Index = 0
			for i = 0, GetTableSize( Childrens ) - 1 do
				local wtChild = Childrens[i]
				local ChildName = wtChild:GetName()
				if ( ChildIndex == Index ) then
					local NewObject = {}
					setmetatable( NewObject, {__index = self})
					NewObject.Widget = wtChild
					return NewObject
				end
				Index = Index + 1
			end
		end	
	end
	return nil
end
---------------------------------------------------------------------------------------------------------------------------
function TWidget:MakeMovable( bMovable, ID )
	if self.Widget then 
		if ( bMovable ) then
			self.bMovable = true
			self.DNDID = ID
			DNDReg( self.Widget, ID )
		else
			self.bMovable = false
			self.DNDID = -1
			DNDUnreg( self.Widget, ID )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
function TWidget:SetPosition( newX, newY )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.posX = math.ceil( newX )
		Placement.posY = math.ceil( newY )
		self.Widget:SetPlacementPlain( Placement )
	end
end
function TWidget:SetWidth( newW )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.sizeX = math.ceil( newW )
		self.Widget:SetPlacementPlain( Placement )
	end
end
function TWidget:SetHeight( newH )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.sizeY = math.ceil( newH )
		self.Widget:SetPlacementPlain( Placement )
	end
end
function TWidget:GetWidth()
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		return Placement.sizeX
	end
end
function TWidget:GetHeight()
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		return Placement.sizeY
	end
end
function TWidget:SetColor( Color )
	if self.Widget then 
		self.Widget:SetBackgroundColor( Color )
	end
end
function TWidget:Show()
	if self.Widget then 
		self.Widget:Show(true)
		if self.bMovable then 
			DNDReg( self.Widget, self.DNDID )
		end
	end
end
function TWidget:Hide()
	if self.Widget then 
		self.Widget:Show(false)
		if self.bMovable then 
			DNDUnreg( self.Widget, self.DNDID )
		end
	end
end
function TWidget:HideAllChild()
	if self.Widget then
		local Childrens = self.Widget:GetNamedChildren()
		if  ( GetTableSize( Childrens ) > 0 ) then
			local Index = 0
			for i = 0, GetTableSize( Childrens ) - 1 do
				local wtChild = Childrens[i]
				wtChild:Show( false )
			end
		end	
	end
end
function TWidget:ShowAllChild()
	if self.Widget then
		local Childrens = self.Widget:GetNamedChildren()
		if  ( GetTableSize( Childrens ) > 0 ) then
			local Index = 0
			for i = 0, GetTableSize( Childrens ) - 1 do
				local wtChild = Childrens[i]
				wtChild:Show( true )
			end
		end	
	end
end

---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------    --------------------------------------
---------------------------------------------------------------------------------------------------------------------------




