---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function GetPercentageAt( Value, ValueAt, bRound )
	local res = Value / ( ValueAt/100 )
	if res~=res then res=0 end
	if bRound then
		res = math.floor( res )
	end
	return res
end
function GetSpellInfoNameFromParams( params )
	if params then 
		local SpellInfo
		local ID
		if params.spellId then 
			SpellInfo = avatar.GetSpellInfo( params.spellId )
			ID = params.spellId
		elseif params.buffId then
			SpellInfo = avatar.GetBuffInfoById( params.buffId )
			ID = params.buffId
		end
		if SpellInfo and not SpellInfo.debugName then
			SpellInfo.debugName = userMods.FromWString(SpellInfo.name)
		end
		return SpellInfo, ID
	else
		return nil, nil
	end
end
function IsThisStringValue( value1, value2 )
	if (type( value1 ) == "string") and (type( value2 ) == "string") then 
		if value1 == value2 then
			return true
		else
			return false
		end
	elseif common.IsWString( value1 ) and common.IsWString( value2 ) then
		local result = common.CompareWString( value1, value2 )
		if result == 0 then 
			return true
		else
			return false
		end
	end
	return false
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TDamageDetails", {} )
---------------------------------------------------------------------------------------------------------------------------
function TDamageDetails:CreateNewObject( Name )
	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	
	NewObject.Name = Name
	NewObject.Type = ""
	NewObject.Count = 0
	NewObject.Percentage = 0
	NewObject.DamageAmount = 0
	NewObject.Min = -1
	NewObject.Mid = -1
	NewObject.Max = -1
	
	return NewObject
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TSpellDamageData", {} )
---------------------------------------------------------------------------------------------------------------------------
function TSpellDamageData:CreateNewObject()
	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	
	NewObject.Name = ""
	NewObject.ID = 0
	NewObject.DebugName = ""
	NewObject.DamageType = ""
	NewObject.DamageAmount = 0
	NewObject.DPS = 0
	NewObject.DamagePercentage = 0
	NewObject.DamageDetailsList = {}
	NewObject.DamageDetailsList[ 1 ] = TDamageDetails:CreateNewObject( "HIT" )
	NewObject.DamageDetailsList[ 2 ] = TDamageDetails:CreateNewObject( "CRIT" )
	NewObject.DamageDetailsList[ 3 ] = TDamageDetails:CreateNewObject( "DODGE" )
	NewObject.DamageDetailsList[ 4 ] = TDamageDetails:CreateNewObject( "GLANCING" )
	NewObject.DamageDetailsList[ 5 ] = TDamageDetails:CreateNewObject( "MISS" )
	
	return NewObject
end
function TSpellDamageData:ReceiveValuesFromParams( params )

	local DamageType = ""
	
	if ( params.isCritical ) and ( params.isCritical == true ) then
		DamageType = "CRIT"
	elseif ( params.isGlancing ) and ( params.isGlancing == true ) then
		DamageType = "GLANCING"
	elseif ( params.isMiss ) and ( params.isMiss == true ) then
		DamageType = "MISS"
	elseif ( params.isDodge ) and ( params.isDodge == true ) then
		DamageType = "DODGE"
	else
		DamageType = "HIT"
	end

	local DamageDetails = self:GetDamageDetailByName( DamageType )
	
	DamageDetails.Count = DamageDetails.Count + 1
	DamageDetails.DamageAmount = DamageDetails.DamageAmount + params.amount
	
	if ( params.amount < DamageDetails.Min )  or ( DamageDetails.Min == -1 ) then
		DamageDetails.Min = params.amount
	end
	if ( params.amount > DamageDetails.Max )  or ( DamageDetails.Max == -1 ) then
		DamageDetails.Max = params.amount
	end
	
	DamageDetails.Mid = math.floor( (DamageDetails.Min + DamageDetails.Max ) / 2 )
	
end
function TSpellDamageData:GetDamageAmount()
	local res = 0
	for i, DamageDetail in  self.DamageDetailsList do
		res = res + DamageDetail.DamageAmount
	end
	return res
end
function TSpellDamageData:GetUseCount()
	local res = 0
	for i, DamageDetail in  self.DamageDetailsList do
		res = res + DamageDetail.Count
	end
	return res
end
function TSpellDamageData:GetDamageDetailByName( Name )
	for i, DamageDetail in  self.DamageDetailsList do
		if IsThisStringValue( DamageDetail.Name, Name ) then
			return DamageDetail
		end
	end
	return nil
end
function TSpellDamageData:SortSpellDetailsByCount()
	for i, DamageDetail1 in  self.DamageDetailsList do
		for j, DamageDetail2 in  self.DamageDetailsList do
			if( self.DamageDetailsList[ j ].Count < self.DamageDetailsList[ i ].Count ) then
				local tmpVal1 = {}
				local tmpVal2 = {}

				tmpVal1 = self.DamageDetailsList[ i ]
				tmpVal2 = self.DamageDetailsList[ j ]

				self.DamageDetailsList[ i ] = nil
				self.DamageDetailsList[ j ] = nil
				
				self.DamageDetailsList[ i ] = {}
				self.DamageDetailsList[ i ] = tmpVal2
				self.DamageDetailsList[ j ] = {}
				self.DamageDetailsList[ j ] = tmpVal1				
			end
		end
	end
end
function TSpellDamageData:CalculateSpellDetailsPercentage()
	local Count = self:GetUseCount()
	for i, DamageDetail in  self.DamageDetailsList do
		DamageDetail.Percentage = GetPercentageAt( DamageDetail.Count , Count, true )
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TCombatant", {} )
---------------------------------------------------------------------------------------------------------------------------
function TCombatant:CreateNewObject( ID )
	local NewObject = {}
	setmetatable( NewObject, {__index = self})

	local Name = object.GetName( ID )
	local Class = unit.GetClass( ID )
	NewObject.Class = Class.className
	NewObject.Name = Name
	NewObject.ID = ID
	NewObject.DamageAmount = 0
	NewObject.DPS = 0
	NewObject.DamagePercentage = 0
	NewObject.bCanUpdate = true
	NewObject.SpellsList = {}

	return NewObject
end
function TCombatant:CreateNewObjectByName( Name )
	local NewObject = {}
	setmetatable( NewObject, {__index = self})

	NewObject.Class = "PRIEST"
	NewObject.Name = Name
	NewObject.ID = nil
	NewObject.DamageAmount = 0
	NewObject.DPS = 0
	NewObject.DamagePercentage = 0
	NewObject.bCanUpdate = false
	NewObject.SpellsList = {}

	return NewObject
end
function TCombatant:GetSpellByNameDebug( DebugName )
	for i, Spell in self.SpellsList do 
		if Spell.DebugName == DebugName then
			return Spell
		end
	end
	return nil
end
function TCombatant:GetSpellByName( Name )
	for i, Spell in self.SpellsList do 
		if IsThisStringValue( Spell.Name, Name ) then
			return Spell
		end
	end
	return nil
end
function TCombatant:GetSpellByIndex( Index )
	local ind = 0
	for i, Spell in self.SpellsList do 
		if ind == Index then
			return Spell
		end
		ind = ind + 1
	end
	return nil
end
function TCombatant:AddNewSpell( params, Name )

	local SpellInfo, ID = GetSpellInfoNameFromParams( params )
	if SpellInfo and ID then 
		local Count = GetTableSize( self.SpellsList )
		self.SpellsList[ Count ] = TSpellDamageData:CreateNewObject()


		if Name then
			self.SpellsList[ Count ].Name  	= Name
		else
			self.SpellsList[ Count ].Name  	= params.ability
		end
		self.SpellsList[ Count ].DebugName 	= SpellInfo.debugName
		self.SpellsList[ Count ].DamageType = params.sysSubElement	
		self.SpellsList[ Count ].ID 		= ID
		
		return self.SpellsList[ Count ]
	else
		return nil
	end
end
function TCombatant:ClearSpellData()
	self.SpellsList = nil
	self.SpellsList = {}
end
function TCombatant:CalculateSpellDamage( FightTime )
	for i, Spell in self.SpellsList do 
		Spell.DamageAmount = Spell:GetDamageAmount()
		Spell.DPS = Spell.DamageAmount / FightTime
		Spell.DamagePercentage = GetPercentageAt( Spell.DamageAmount, self.DamageAmount, true )
		Spell:CalculateSpellDetailsPercentage()
		Spell:SortSpellDetailsByCount()
	end
end
function TCombatant:SortSpellByDamageAmount()

	for i, Spell1 in self.SpellsList do 
		for j, Spell2 in self.SpellsList do 
			if( self.SpellsList[ j ].DamageAmount < self.SpellsList[ i ].DamageAmount ) then
				local tmpVal1 = {}
				local tmpVal2 = {}

				tmpVal1 = self.SpellsList[ i ]
				tmpVal2 = self.SpellsList[ j ]

				self.SpellsList[ i ] = nil
				self.SpellsList[ j ] = nil
				
				self.SpellsList[ i ] = {}
				self.SpellsList[ i ] = tmpVal2
				self.SpellsList[ j ] = {}
				self.SpellsList[ j ] = tmpVal1				
			end
		end
	end
	
end
function TCombatant:UpdateCombatantDataByID( ID )
	self.ID = ID
	if( ID ) then
		local Name = object.GetName( ID )
		local Class = unit.GetClass( ID )
	
		self.Class = Class.className
		self.Name = Name
	else
		self.Class = "PRIEST"
		self.Name = self.Name
	end
	
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TFight", {} )
Global( "bForceSetCombatMode", false )
---------------------------------------------------------------------------------------------------------------------------
function TFight:CreateNewObject( Name )
	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	
	NewObject.Name = Name
	NewObject.FightTime = 1
	NewObject.DamageAmount = 0
	NewObject.CombatantsList = {}
	
	return NewObject
end
---------------------------------------------------------------------------------------------------------------------------
function TFight:AddNewCombatant( ID )
	local Count = GetTableSize( self.CombatantsList )
	local NewCombatantName = object.GetName( ID )
	local NewCombatant = self:GetCombatantByName( NewCombatantName )
	if NewCombatant ==  nil then 
		self.CombatantsList[ Count ] = TCombatant:CreateNewObject( ID )
	end
end
function TFight:AddNewCombatantByName( Name )
	local Count = GetTableSize( self.CombatantsList )
	local NewCombatant = self:GetCombatantByName( Name )
	if NewCombatant ==  nil then 
		self.CombatantsList[ Count ] = TCombatant:CreateNewObjectByName( Name )
	end
end
function TFight:RemoveCombatantByName( Name )
	local NewCombatantsList = {}
	local ind = 0
	for i, Combatant in self.CombatantsList do 
		if not IsThisStringValue( Combatant.Name, Name ) then
			NewCombatantsList[ ind ] = Combatant
			ind = ind + 1
		end
	end	
	self.CombatantsList = NewCombatantsList
end
function TFight:GetCombatantByName( Name )
	for i, Combatant in self.CombatantsList do 
		if IsThisStringValue( Combatant.Name, Name ) then
			return Combatant
		end
	end
	return nil
end
function TFight:GetCombatantByID( ID )
	for i, Combatant in self.CombatantsList do 
		if Combatant.bCanUpdate then 
			if Combatant.ID == ID then
				return Combatant
			end
		end
	end
	return nil
end
function TFight:GetCombatantByIndex( Index )
	local ind = 0
	for i, Combatant in self.CombatantsList do 
		if ind == Index then
			return Combatant
		end
		ind = ind + 1
	end
	return nil
end
function TFight:GetCombatantNameByIndex( Index )
	local id = 0
	for i, Combatant in self.CombatantsList do 
		if id == Index then
			return Combatant.Name
		end
		id = id + 1
	end
	return ""
end
function TFight:GetCombatantCount()
	return GetTableSize( self.CombatantsList )
end
---------------------------------------------------------------------------------------------------------------------------
function TFight:GetCombatantDamageData( Combatant, params )

	if Combatant.bCanUpdate then
		if (params.source) and ( params.source == Combatant.ID ) and ( params.target ~=  Combatant.ID ) then

			if (params.amount) and ( not params.isFall )  then 
				
				Combatant.DamageAmount = Combatant.DamageAmount + params.amount
				Combatant.DPS = Combatant.DamageAmount / self.FightTime
				
				local SpellInfo, ID = GetSpellInfoNameFromParams( params )
				
				if SpellInfo then
					local Spell = Combatant:GetSpellByNameDebug( SpellInfo.debugName )

					if( Spell == nil ) then 
						Spell = Combatant:AddNewSpell( params )
					end
					
					if Spell then Spell:ReceiveValuesFromParams( params ) end
				end
				
			end

		elseif (params.source) and ( unit.IsPet( params.source ) ) and ( unit.GetPetOwner( params.source ) ==  Combatant.ID ) then
			
			if ( params.amount ) then 
				Combatant.DamageAmount = Combatant.DamageAmount + params.amount
				Combatant.DPS = Combatant.DamageAmount / self.FightTime
				
				local PetName = object.GetName( params.source )
				
				local Spell = Combatant:GetSpellByName( PetName )
				
				if( Spell == nil ) then 
					Spell = Combatant:AddNewSpell( params, PetName )
				end
				if Spell then 
					Spell:ReceiveValuesFromParams( params )
					Spell.DamageType = "ENUM_SubElement_PHYSICAL"
				end
				
			end	
			
		end
	end

end
---------------------------------------------------------------------------------------------------------------------------
function TFight:CalculateDamage()
	self.DamageAmount = 0
	for i, Combatant in self.CombatantsList do 
		self.DamageAmount = self.DamageAmount + Combatant.DamageAmount 
	end
end
function TFight:UpdateCombatantsData( params )
	if params then 
		for i, Combatant in self.CombatantsList do 
			if Combatant.bCanUpdate then
				self:GetCombatantDamageData( Combatant, params )
			end
		end
	end
	
	self:CalculateDamage()
	
	for i, Combatant in self.CombatantsList do 
		Combatant.DamagePercentage = GetPercentageAt( Combatant.DamageAmount, self.DamageAmount, true )
		Combatant:CalculateSpellDamage( self.FightTime )
		Combatant:SortSpellByDamageAmount()
	end
	
	self:SortCombatantsByDamageAmount()
	
end
function TFight:ClearCombatatnsData()
	for i, Combatant in self.CombatantsList do 
		Combatant.DamageAmount = 0
		Combatant.DPS = 0
		Combatant.DamagePercentage = 0
		Combatant:ClearSpellData()
	end
end
function TFight:IsCombatantsInCombat()
	if bForceSetCombatMode then 
		return true
	else
		local inCombatCount = 0
		for i, Combatant in self.CombatantsList do 
			if Combatant.bCanUpdate then 
				local inCombat = unit.IsInCombat( Combatant.ID )
				if  ( inCombat ) then
					inCombatCount = inCombatCount + 1
				end		
			end
		end
		if ( inCombatCount == 0 ) then 
			return false
		elseif ( inCombatCount > 0 ) then 
			return true
		end	
	end
end
function TFight:IsCombatantsInCombatWithoutForceSet()
	local inCombatCount = 0
	for i, Combatant in self.CombatantsList do 
		if Combatant.bCanUpdate then 
			local inCombat = unit.IsInCombat( Combatant.ID )
			if  ( inCombat ) then
				inCombatCount = inCombatCount + 1
			end		
		end
	end
	if ( inCombatCount == 0 ) then 
		return false
	elseif ( inCombatCount > 0 ) then 
		return true
	end	
end
function TFight:SortCombatantsByDamageAmount()

	for i, Combatant1 in self.CombatantsList do 
		for j, Combatant2 in self.CombatantsList do 
			if( self.CombatantsList[ j ].DamageAmount < self.CombatantsList[ i ].DamageAmount ) then
				local tmpVal1 = {}
				local tmpVal2 = {}

				tmpVal1 = self.CombatantsList[ i ]
				tmpVal2 = self.CombatantsList[ j ]

				self.CombatantsList[ i ] = nil
				self.CombatantsList[ j ] = nil
				
				self.CombatantsList[ i ] = {}
				self.CombatantsList[ i ] = tmpVal2
				self.CombatantsList[ j ] = {}
				self.CombatantsList[ j ] = tmpVal1				
			end
		end
	end
	
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TDPSMeter", {} )
---------------------------------------------------------------------------------------------------------------------------
function TDPSMeter:CreateNewObject()
	local NewObject = {}
	setmetatable( NewObject, {__index = self})
	
	NewObject.FightsList = {}
	NewObject.bCollectData = false
	NewObject.ResetFightName = ""
	
	return NewObject
end
function TDPSMeter:AddNewFight( Name )
	local Count = GetTableSize( self.FightsList )
	self.FightsList[ Count ] = TFight:CreateNewObject( Name )
end
function TDPSMeter:GetFightByName( Name )
	for i, Fight in self.FightsList do 
		if IsThisStringValue( Fight.Name , Name ) then
			return Fight
		end
	end
	return nil
end
function TDPSMeter:AddNewCombatant( ID )
	for i, Fight in self.FightsList do 
		Fight:AddNewCombatant( ID )
	end
end
function TDPSMeter:SetCombatantUpdateStatusByName( Name, bCanUpdate )
	for i, Fight in self.FightsList do 
		local Combatant = Fight:GetCombatantByName( Name )
		if Combatant then
			Combatant.bCanUpdate = bCanUpdate;
		end
	end
end
function TDPSMeter:AddNewCombatantByName( Name )
	for i, Fight in self.FightsList do 
		Fight:AddNewCombatantByName( Name )
	end
end
function TDPSMeter:RemoveAllCombatants()
	for i, Fight in self.FightsList do 
		Fight.CombatantsList = nil
		Fight.CombatantsList = {}
	end
end
function TDPSMeter:GetAllCombatants()
	return self.FightsList[ 0 ].CombatantsList
end
function TDPSMeter:RemoveCombatantByName( Name )
	for i, Fight in self.FightsList do 
		Fight:RemoveCombatantByName( Name )
	end
end
function TDPSMeter:IsCombatantsInCombatWithoutForceSet()
	local bInCombat = false
	for i, Fight in self.FightsList do 
		bInCombat = Fight:IsCombatantsInCombatWithoutForceSet()
		if bInCombat then 
			return true
		end
	end
	return false
end
function TDPSMeter:IsParamsHaveCombatatnts( params )
	local bIsOurCombatantParams = false
	if params then
		for i, Fight in self.FightsList do 
			for j, Combatant in Fight.CombatantsList do 
				--if Combatant.bCanUpdate and ( Combatant.ID == params.source or ( ( unit.IsPet(params.source) ) and ( unit.GetPetOwner(params.source) == Combatant.ID) ) ) then
				if Combatant.bCanUpdate and Combatant.ID == params.source then
					bIsOurCombatantParams = true
				end
			end
		end
	end
	return bIsOurCombatantParams
end
function TDPSMeter:UpdateFightsData( params )
	
	local IsParamsHaveCombatatnts = self:IsParamsHaveCombatatnts( params )
	
	if (not self.bCollectData) and IsParamsHaveCombatatnts then
		bForceSetCombatMode = true
		self.bCollectData = true
		self:ResetFightByName( self.ResetFightName )
	elseif self:IsCombatantsInCombatWithoutForceSet() then
		bForceSetCombatMode = false
	end
	
	for i, Fight in self.FightsList do 
		 Fight:UpdateCombatantsData( params )
	end
end
function TDPSMeter:UpdateFightsTime()
	for i, Fight in self.FightsList do 
		 Fight.FightTime = Fight.FightTime + 1
	end
end
function TDPSMeter:ResetAllFights()
	for i, Fight in self.FightsList do 
		 Fight.FightTime = 1
		 Fight.DamageAmount = 0
		 Fight:ClearCombatatnsData()
	end
end
function TDPSMeter:ResetFightByName( Name )
	local Fight = self:GetFightByName( Name )
	Fight.FightTime = 1
	Fight.DamageAmount = 0
	Fight:ClearCombatatnsData()
end

---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
