---------------------------------------------------------------------------------------------------
-- Locales
---------------------------------------------------------------------------------------------------
local GetTextGroup = common.GetAddonRelatedTextGroup
---------------------------------------------------------------------------------------------------
Global( "locales", {} )
local locales = locales
---------------------------------------------------------------------------------------------------
for _, sysGroup in { "eng", "rus", "ger", "fra", "br", "jpn" } do
	local group = GetTextGroup( sysGroup )
	if group then
		locales[ sysGroup ] = {}
		for _, sysName in { 
			"Addon Manager",
			"Cancel",
			"Description",
			"Empty",
			"Default",
			"Language",
			"Load All",
			"Load Selected",
			"Locale",
			"Lock",
			"Hide All",
			"Memory Usage",
			"Name",
			"Reset",
			"Save",
			"Show All",
			"State",
			"Unload All",
			"Unload Selected",
			"User"
		} do
			if group:HasText( sysName ) then locales[ sysGroup ][ sysName ] = group:GetText( sysName ) end
		end
	end
end
---------------------------------------------------------------------------------------------------