---------------------------------------------------------------------------------------------------
-- Common Utilities
---------------------------------------------------------------------------------------------------
--[[
rawset( _G, "print", function( ... )
	local t = {}
	for i = 1, arg.n do
		local v = arg[ i ]
		table.insert( t, common.IsWString( v ) and v or tostring( v ) )
	end
	common.LogInfo( "", unpack( t ) )
end )--]]
---------------------------------------------------------------------------------------------------
rawset( table, "isempty", function( t )
	--assert( type( t ) == "table", "bad argument #1 to `isempty' (table expected, got " .. type( t ) .. ")" )
	for _ in t do return false end
	return true
end )
---------------------------------------------------------------------------------------------------
rawset( _G, "toboolean", function( value )
	if not value or ( type( value ) == "number" and value == 0 ) or ( type( value ) == "string" and value == "" ) then return false end
	return true
end )
---------------------------------------------------------------------------------------------------
do
	local _tonumber = tonumber
	tonumber = function( var )
		if type( var ) == "boolean" or not var then
			var = var and 1 or 0
		else
			var = _tonumber( var )
		end
		return var
	end
end
---------------------------------------------------------------------------------------------------
function W( name, parent ) return parent and parent:GetChildChecked( name, true ) or mainForm:GetChildChecked( name, true ) end
function ToWS( string ) return string and userMods.ToWString( type( string ) == "string" and string or tostring( string ) ) or common.GetEmptyWString() end
--function FromWS( wstring ) return common.IsWString( wstring ) and userMods.FromWString( wstring ) or wstring end
---------------------------------------------------------------------------------------------------