---------------------------------------------------------------------------------------------------
-- Addon Manager: Popup
---------------------------------------------------------------------------------------------------
local W = W
---------------------------------------------------------------------------------------------------
Global( "AddonManager", {} )
local popup = { state = false }
AddonManager.popup = popup
---------------------------------------------------------------------------------------------------
popup.GetWidgets = function( self )
	self.widget = W( "Popup" )
	self.container = W( "Container", self.widget )
end

popup.AddItem = function( self, name )
	local widget
	if not self.itemDesc then
		widget = W( "PopupItem" )
		self.itemDesc = widget:GetWidgetDesc()
	else
		widget = mainForm:CreateWidgetByDesc( self.itemDesc )
	end
	widget:SetName( name )
	local placement = widget:GetPlacementPlain()
	widget:SetVal( "value", locales[ name ][ "Locale" ] )
	widget:Show( true )
	self.container:PushBack( widget )
end

popup.SetPlacement = function( self, widget )
	local placement = self.widget:GetPlacementPlain()
	local widgetPlacement = widget:GetPlacementPlain()	
	placement.alignX = widgetPlacement.alignX
	placement.alignY = placement.alignX	
	placement.highPosX = widgetPlacement.highPosX - 5 							--ugly :'(
	placement.highPosY = widgetPlacement.highPosY + widgetPlacement.sizeY - 5	--
	self.widget:SetPlacementPlain( placement )
end

popup.Toggle = function( self, state ) self.widget:Show( state ) end

popup.Init = function( self )
	self:GetWidgets()
	for locale in locales do self:AddItem( locale )	end
	self:SetPlacement( W( "LanguagePanel" ) )
end
---------------------------------------------------------------------------------------------------