---------------------------------------------------------------------------------------------------
-- SCRIPT_TOGGLE_UI
---------------------------------------------------------------------------------------------------
function ToggleUI()
	if currencyExchange then return end -- v.2.0.07.08+
	local widget = stateMainForm:GetChildUnchecked( "CurrentShard", true )
	if not widget then return end
	mainForm:PlayFadeEffect( 1.0, 1.0, 100, EA_MONOTONOUS_INCREASE )
	local visibility = { widget:GetParent() }
	table.insert( visibility, visibility[ 1 ]:GetParent() )
	common.RegisterEventHandler(
		function( event )
			if event.effectType == ET_FADE and event.wtOwner:IsEqual( mainForm ) then
				mainForm:PlayFadeEffect( 1.0, 1.0, 100, EA_MONOTONOUS_INCREASE )
				local isVisible = not visibility[ 1 ]:IsVisible() and visibility[ 2 ]:IsVisible()
				if visibility[ 3 ] ~= isVisible then
					userMods.SendEvent( "SCRIPT_TOGGLE_UI", { visible = isVisible } )
					visibility[ 3 ] = isVisible
				end
			end
		end,
		"EVENT_EFFECT_FINISHED"
	)
	--ToggleUI = nil
end
---------------------------------------------------------------------------------------------------