---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "enumHit", { Normal = 1, Critical = 2, Glancing = 3, Dodge = 4, Miss = 5 } )
Global( "enumBlock", { Block = 1, Parry = 2, Barrier = 3, Resist = 4, Absorb = 5 } )
Global( "enumEnemy", { Attacked = 1, Killed = 2, Lost = 3 } )
Global( "strPet", userMods.FromWString( GetTextLocalized( "Pet" ) ) )
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

group.IsPlayerInGroup = group.IsPlayerInGroup or group.IsCreatureInGroup

--------------------------------------------------------------------------------
--   (http://oentend.blogspot.com/2009/08/lua.html)
--------------------------------------------------------------------------------
function CopyObject( object )
	local lookup_table = {}
	--
	local function _copy( object )
		if type( object ) ~= "table" then
			return object
		elseif lookup_table[object] then
			return lookup_table[object]
		end
		--
		local new_table = {}
		lookup_table[object] = new_table
		for index, value in pairs( object ) do
			new_table[ _copy( index ) ] = _copy( value )
		end
		--
		return setmetatable( new_table, _copy( getmetatable( object ) ) )
	end
	--
	return _copy( object )
end
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
function GetPercentageAt( Value, ValueAt )
	return math.floor( ( ValueAt ~= 0 and Value / ValueAt or 0 ) * 100 )
end
--------------------------------------------------------------------------------
function GetSpellInfoNameFromParams( params )
	if params then
		local ID = params.spellId or params.buffId
		local info = params.spellId and avatar.GetSpellInfo( ID )
			or params.buffId and avatar.GetBuffInfoById( ID )
		
		if info and not info.debugName then
			info.debugName = userMods.FromWString( info.name )
		end
		
		return info, ID
	end
end
--------------------------------------------------------------------------------
function IsThisStringValue( value1, value2 )
	if common.IsWString( value1 ) and common.IsWString( value2 ) then
		return common.CompareWString( value1, value2 ) == 0
	else
		return type( value1 ) == "string" and value1 == value2
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TDamageDetails", {} )
---------------------------------------------------------------------------------------------------------------------------
function TDamageDetails:CreateNewObject( ID )
	return setmetatable( {
		ID = ID,
		Type = "",
		Count = 0,
		Percentage = 0,
		DamageAmount = 0,
		Min = -1,
		Avg = -1,
		Max = -1,
	}, { __index = self } )
end
---------------------------------------------------------------------------------------------------------------------------
--  min, max, avg
function TDamageDetails:RecalcDamageDetails( value )
	-- 
	self.Count = self.Count + 1
	--  
	self.DamageAmount = self.DamageAmount + value
	--  
	if ( value < self.Min ) or ( self.Min == -1 ) then self.Min = value; end
	--  
	if ( value > self.Max ) or ( self.Max == -1 ) then self.Max = value; end
	--  
	--self.Avg = math.ceil( self.DamageAmount / self.Count )
end
--------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TSpellDamageData", {} )
---------------------------------------------------------------------------------------------------------------------------
function TSpellDamageData:CreateNewObject()
	return setmetatable( {
		Name = "",
		ID = 0,
		DebugName = "",
		Count = 0,
		Hits = 0,
		DamageType = "",
		DamageAmount = 0,
		DPS = 0,
		DamagePercentage = 0,
		DamageDetailsList = {
			[enumHit.Normal]	= TDamageDetails:CreateNewObject( enumHit.Normal, "Normal" ),
			[enumHit.Critical]	= TDamageDetails:CreateNewObject( enumHit.Critical, "Critical" ),
			[enumHit.Glancing]	= TDamageDetails:CreateNewObject( enumHit.Glancing, "Glancing" ),
			[enumHit.Dodge]		= TDamageDetails:CreateNewObject( enumHit.Dodge, "Dodge" ),
			[enumHit.Miss]		= TDamageDetails:CreateNewObject( enumHit.Miss, "Miss" )
		},
		--
		BlockDmgAmount = 0,
		BlockDmgPercentage = 0,
		BlockDmgDetailsList = {
			[enumBlock.Block]	= TDamageDetails:CreateNewObject( enumBlock.Block, "Block" ),
			[enumBlock.Parry]	= TDamageDetails:CreateNewObject( enumBlock.Parry, "Parry" ),
			[enumBlock.Barrier]	= TDamageDetails:CreateNewObject( enumBlock.Barrier, "Barrier" ),
			[enumBlock.Resist]	= TDamageDetails:CreateNewObject( enumBlock.Resist, "Resist" ),
			[enumBlock.Absorb]	= TDamageDetails:CreateNewObject( enumBlock.Absorb, "Absorb" )
		}
	}, { __index = self } )
end
--------------------------------------------------------------------------------
function TSpellDamageData:ReceiveValuesFromParams( params )
	local DamageDetails

	--  
	self.Count = self.Count + 1;
	
	--  
	self.DamageAmount = self.DamageAmount + params.amount;
	
	--   
	-- 
	if params.isMiss then
		self.DamageDetailsList[enumHit.Miss]:RecalcDamageDetails( params.amount )
	end

	-- 
	if params.isDodge then
		self.DamageDetailsList[enumHit.Dodge]:RecalcDamageDetails( params.amount )
	end

	--      ,  
	if not params.isMiss and not params.isDodge then
		--  
		self.Hits = self.Hits + 1;
		
		--  
		if params.isCritical then
			self.DamageDetailsList[enumHit.Critical]:RecalcDamageDetails( params.amount )
		end

		--  
		if params.isGlancing then
			self.DamageDetailsList[enumHit.Glancing]:RecalcDamageDetails( params.amount )
		end

		--   (..     -)
		if not params.isCritical and not params.isGlancing then
			self.DamageDetailsList[enumHit.Normal]:RecalcDamageDetails( params.amount )
		end
	end

	--  
	if params.shieldBlock > 0 then
		self.BlockDmgDetailsList[enumBlock.Block]:RecalcDamageDetails( params.shieldBlock )
	end

	-- 
	if params.parry > 0 then
		self.BlockDmgDetailsList[enumBlock.Parry]:RecalcDamageDetails( params.parry )
	end

	--  
	if params.barrier > 0 then
		self.BlockDmgDetailsList[enumBlock.Barrier]:RecalcDamageDetails( params.barrier )
	end

	--  	
	if params.resist > 0 then
		self.BlockDmgDetailsList[enumBlock.Resist]:RecalcDamageDetails( params.resist )
	end

	-- 
	if params.absorb > 0 then
		self.BlockDmgDetailsList[enumBlock.Absorb]:RecalcDamageDetails( params.absorb )
	end
	
end
--------------------------------------------------------------------------------
function TSpellDamageData:GetDamageAmount()
	return self.DamageAmount
end
--------------------------------------------------------------------------------
function TSpellDamageData:GetBlockDmgAmount()
	local res = 0
	for i, BlockDmgDetail in self.BlockDmgDetailsList do
		res = res + BlockDmgDetail.DamageAmount
	end
	return res
end
--------------------------------------------------------------------------------
function TSpellDamageData:GetUseCount()
	return self.Count
end
--------------------------------------------------------------------------------
function TSpellDamageData:GetUseHits()
	return self.Hits
end
--------------------------------------------------------------------------------
--local function CompareDamageDetails( A, B )
--	return A.Count > B.Count
--end
--------------------------------------------------------------------------------
--local function CompareBlockDmgDetails( A, B )
--	return A.DamageAmount > B.DamageAmount
--end
--------------------------------------------------------------------------------
function TSpellDamageData:SortSpellDetailsByCount()
--	table.sort( self.DamageDetailsList, CompareDamageDetails )
	--
--	table.sort( self.BlockDmgDetailsList, CompareBlockDmgDetails )
end
--------------------------------------------------------------------------------
local function CompareSpellDetails( A, B )
	local AA = tonumber(string.sub(A, 3))
	local BB = tonumber(string.sub(B, 3))
	return AA > BB
end
---------------------------------------------------------------------------------------------------------------------------
function TSpellDamageData:SortSpellDetailsByDamageTypes()
	local a = {}
	local DamageType, DamageDetails
	--
	for DamageType, DamageDetails in pairs(self.DamageDetailsList) do
		table.insert(a, DamageType.."_"..DamageDetails.Count)
	end
	--
	table.sort(a, CompareSpellDetails)
	--
	local i = 0      -- iterator variable
	local iter = function ()   -- iterator function
		i = i + 1
		if a[i] == nil then return nil
		else return tonumber(string.sub(a[i], 1, 1))
		end
	end
	return iter
end
---------------------------------------------------------------------------------------------------------------------------
function TSpellDamageData:SortSpellDetailsByBlockDmgs()
	local a = {}
	local DamageType, DamageDetails
	--
	for BlockDmgType, BlockDmgDetails in pairs(self.BlockDmgDetailsList) do
		table.insert(a, BlockDmgType.."_"..BlockDmgDetails.DamageAmount)
	end
	--
	table.sort(a, CompareSpellDetails)
	--
	local i = 0      -- iterator variable
	local iter = function ()   -- iterator function
		i = i + 1
		if a[i] == nil then return nil
		else return tonumber(string.sub(a[i], 1, 1))
		end
	end
	return iter
end
--------------------------------------------------------------------------------
function TSpellDamageData:CalculateSpellDetailsPercentage()
--	local Count = self:GetUseCount()
--	for i, DamageDetail in self.DamageDetailsList do
--		DamageDetail.Percentage = GetPercentageAt( DamageDetail.Count, Count )
--	end
	--
	local Count = self:GetUseCount()
	self.DamageDetailsList[ enumHit.Dodge ].Percentage = GetPercentageAt( self.DamageDetailsList[ enumHit.Dodge ].Count, Count )
	self.DamageDetailsList[ enumHit.Miss ].Percentage = GetPercentageAt( self.DamageDetailsList[ enumHit.Miss ].Count, Count )
	--
	local Hits = self:GetUseHits()
	self.DamageDetailsList[ enumHit.Critical ].Percentage = GetPercentageAt( self.DamageDetailsList[ enumHit.Critical ].Count, Hits )
	self.DamageDetailsList[ enumHit.Glancing ].Percentage = GetPercentageAt( self.DamageDetailsList[ enumHit.Glancing ].Count, Hits )
	self.DamageDetailsList[ enumHit.Normal ].Percentage = GetPercentageAt( self.DamageDetailsList[ enumHit.Normal ].Count, Hits )
	--
	local BlockDmg = self:GetBlockDmgAmount()
	local AllDamage = self.DamageAmount + self.BlockDmgAmount
	for i, BlockDmgDetail in self.BlockDmgDetailsList do
		BlockDmgDetail.Percentage = GetPercentageAt( BlockDmgDetail.DamageAmount, AllDamage )
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TCombatant", {} )
---------------------------------------------------------------------------------------------------------------------------
function TCombatant:CreateNewObject( ID )
	return setmetatable( {
		ID = ID,
		Name = object.GetName( ID ),
--		Class = unit.GetClass( ID ).className,
		Class = unit.GetClass( ID ).className or "UNKNOWN",
--		Pet = ( group.IsPlayerInGroup( ID ) or ID == avatar.GetId() ) and unit.GetActivePet( ID ) and object.GetName( unit.GetActivePet( ID ) ) or nil,
		Pet = unit.IsPlayer( ID ) and ( group.IsPlayerInGroup( ID ) or ID == avatar.GetId() ) and unit.GetActivePet( ID ) and object.GetName( unit.GetActivePet( ID ) ) or nil,
		DamageAmount = 0,
		DPS = 0,
		DamagePercentage = 0,
		LeaderPercentage = 0,
		bCanUpdate = true,
		SpellsList = {},
	}, { __index = self } )
end
--------------------------------------------------------------------------------
function TCombatant:CreateNewObjectByName( Name )
	return setmetatable( {
		ID = nil,
		Name = Name,
		Class = "PRIEST",
		Pet = nil,
		DamageAmount = 0,
		DPS = 0,
		DamagePercentage = 0,
		LeaderPercentage = 0,
		bCanUpdate = false,
		SpellsList = {},
	}, { __index = self } )
end
--------------------------------------------------------------------------------
function TCombatant:GetSpellByIdentifier( DebugName, DamageType )
	local Identifier = DebugName .. ( DamageType or "" )
	for i, Spell in self.SpellsList do
		if Spell.Identifier == Identifier then
			return Spell
		end
	end
	return nil
end
--------------------------------------------------------------------------------
function TCombatant:GetSpellByName( Name )
	for i, Spell in self.SpellsList do
		if IsThisStringValue( Spell.Name, Name ) then
			return Spell
		end
	end
	return nil
end
--------------------------------------------------------------------------------
function TCombatant:GetSpellByIndex( Index )
	return self.SpellsList[ Index ]
end
--------------------------------------------------------------------------------
function TCombatant:AddNewSpell( params, Name )
	local SpellInfo, ID = GetSpellInfoNameFromParams( params )
	
	if SpellInfo and ID then
		local Spell = TSpellDamageData:CreateNewObject()
		Spell.Name = Name or params.ability
		Spell.Identifier = SpellInfo.debugName .. ( params.sysSubElement or "" )
		Spell.DamageType = params.sysSubElement
		Spell.ID = ID
		
		table.insert( self.SpellsList, Spell )
		return Spell
	end
end
--------------------------------------------------------------------------------
function TCombatant:ClearSpellData()
	self.SpellsList = {}
end
--------------------------------------------------------------------------------
local function CompareSpells( A, B )
	return A.DamageAmount > B.DamageAmount
end
--------------------------------------------------------------------------------
function TCombatant:SortSpellByDamageAmount()
	table.sort( self.SpellsList, CompareSpells )
end
--------------------------------------------------------------------------------
function TCombatant:CalculateSpellDamage( FightTime )
	local FightTimeNormalized = FightTime ~= 0 and FightTime or 1
	for i, Spell in self.SpellsList do
		Spell.DamageAmount = Spell:GetDamageAmount()
		Spell.BlockDmgAmount = Spell:GetBlockDmgAmount()
		Spell.DPS = Spell.DamageAmount / FightTimeNormalized
		Spell.DamagePercentage = GetPercentageAt( Spell.DamageAmount, self.DamageAmount )
		Spell:CalculateSpellDetailsPercentage()
		Spell.BlockDmgPercentage = GetPercentageAt( Spell.BlockDmgAmount, ( Spell.DamageAmount + Spell.BlockDmgAmount ))
		Spell:SortSpellDetailsByCount()
	end
	self:SortSpellByDamageAmount()
end
--------------------------------------------------------------------------------
function TCombatant:UpdateCombatantDataByID( ID )
	if not ID then return end
	self.ID = ID
	self.Name = object.GetName( ID )
--	self.Class = unit.GetClass( ID ).className
	self.Class = unit.GetClass( ID ).className or "UNKNOWN"
--	self.Pet = ( group.IsPlayerInGroup( ID ) or ID == avatar.GetId() ) and unit.GetActivePet( ID ) and object.GetName( unit.GetActivePet( ID ) ) or nil
	self.Pet = unit.IsPlayer( ID ) and ( group.IsPlayerInGroup( ID ) or ID == avatar.GetId() ) and unit.GetActivePet( ID ) and object.GetName( unit.GetActivePet( ID ) ) or nil
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TFight", {} )
---------------------------------------------------------------------------------------------------------------------------
function TFight:CreateNewObject( ID )
	return setmetatable( {
		ID = ID,
		FightTime = 0,
		DamageAmount = 0,
		DPS = 0,
		CombatantsList = {},
		Opponents = {},
	}, { __index = self } )
end
--------------------------------------------------------------------------------
function TFight:AddNewCombatant( ID )
	if not self:GetCombatantByName( object.GetName( ID ) ) then
		table.insert( self.CombatantsList, TCombatant:CreateNewObject( ID ) )
	end
end
--------------------------------------------------------------------------------
function TFight:AddNewCombatantByName( Name )
	if not self:GetCombatantByName( Name ) then
		table.insert( self.CombatantsList, TCombatant:CreateNewObjectByName( Name ) )
	end
end
--------------------------------------------------------------------------------
function TFight:RemoveCombatantByName( Name )
	local Combatant, index = self:GetCombatantByName( Name )
	
	if index then
		table.remove( self.CombatantsList, index )
	end
end
--------------------------------------------------------------------------------
function TFight:GetCombatantByName( Name )
	for i, Combatant in self.CombatantsList do
		if IsThisStringValue( Combatant.Name, Name ) then
			return Combatant, i
		end
	end
	return nil
end
--------------------------------------------------------------------------------
function TFight:GetCombatantByID( ID )
	for i, Combatant in self.CombatantsList do
		if Combatant.bCanUpdate and Combatant.ID == ID then
			return Combatant
		end
	end
	return nil
end
--------------------------------------------------------------------------------
function TFight:GetCombatantByIndex( Index )
	return self.CombatantsList[ Index ]
end
--------------------------------------------------------------------------------
function TFight:GetCombatantNameByIndex( Index )
	local Combatant = self.CombatantsList[ Index ]
	return Combatant and Combatant.Name or ""
end
--------------------------------------------------------------------------------
function TFight:GetCombatantCount()
	return table.getn( self.CombatantsList ) or 0
end
--------------------------------------------------------------------------------
function TFight:ClearCombatantsData()
	for i, Combatant in self.CombatantsList do
		Combatant.DamageAmount = 0
		Combatant.DPS = 0
		Combatant.DamagePercentage = 0
		Combatant.LeaderPercentage = 0
		Combatant:ClearSpellData()
	end
end
--------------------------------------------------------------------------------
local function CompareCombatantsByDamageAmount( A, B )
	if A.DamageAmount == B.DamageAmount then
		return common.CompareWString( A.Name, B.Name ) == -1 end
	return A.DamageAmount > B.DamageAmount
end
--------------------------------------------------------------------------------
function TFight:SortCombatantsByDamageAmount()
	table.sort( self.CombatantsList, CompareCombatantsByDamageAmount )
end
--------------------------------------------------------------------------------
function TFight:RecalculateCombatantsData()
	local FightTimeNormalized = self.FightTime ~= 0 and self.FightTime or 1
	--
	self.DamageAmount = 0
	for i, Combatant in self.CombatantsList do
		self.DamageAmount = self.DamageAmount + Combatant.DamageAmount
	end
	--
	self.DPS = self.DamageAmount / FightTimeNormalized
	--
	for i, Combatant in self.CombatantsList do
		Combatant.DPS = Combatant.DamageAmount / FightTimeNormalized
		Combatant.DamagePercentage = GetPercentageAt( Combatant.DamageAmount, self.DamageAmount )
	end
	--
	self:SortCombatantsByDamageAmount()
	local ImbaCombatant = self.CombatantsList[ 1 ]
	if ImbaCombatant then
		local LeaderDamageAmount = ImbaCombatant.DamageAmount
		for i, Combatant in self.CombatantsList do
			Combatant.LeaderPercentage = GetPercentageAt( Combatant.DamageAmount, LeaderDamageAmount )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TDPSMeter", {} )
---------------------------------------------------------------------------------------------------------------------------
function TDPSMeter:CreateNewObject()
	return setmetatable( {
		FightsList = {},
		bCollectData = false,
		LastHitTime = 0,
		OffBattleTime = false,
		Fight = { Total = nil, Current = nil, Prev = nil }
	}, { __index = self } )
end
--------------------------------------------------------------------------------
function TDPSMeter:AddNewFight()
	table.insert( self.FightsList, TFight:CreateNewObject( table.getn( self.FightsList ) + 1 ) )
	return table.getn( self.FightsList )
end
--------------------------------------------------------------------------------
function TDPSMeter:GetFight( ID )
	return self.FightsList[ ID ]
end
--------------------------------------------------------------------------------
function TDPSMeter:AddNewCombatant( ID )
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then
			self.FightsList[ FightID ]:AddNewCombatant( ID )
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:SetCombatantUpdateStatusByName( Name, bCanUpdate )
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then
			local Combatant = self.FightsList[ FightID ]:GetCombatantByName( Name )
			if Combatant then
				Combatant.bCanUpdate = bCanUpdate
			end
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:AddNewCombatantByName( Name )
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then
			self.FightsList[ FightID ]:AddNewCombatantByName( Name )
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:GetPrevCombatants()
	return self.FightsList[ self.Fight.Prev ].CombatantsList
end
--------------------------------------------------------------------------------
function TDPSMeter:GetCurrentCombatants()
	return self.FightsList[ self.Fight.Current ].CombatantsList
end
--------------------------------------------------------------------------------
function TDPSMeter:GetTotalCombatants()
	return self.FightsList[ self.Fight.Total ].CombatantsList
end
--------------------------------------------------------------------------------
function TDPSMeter:RemoveCombatantByName( Name )
	self.FightsList[ self.Fight.Current ]:RemoveCombatantByName( Name )
	self.FightsList[ self.Fight.Total ]:RemoveCombatantByName( Name ) -- ?
	self.FightsList[ self.Fight.Prev ]:RemoveCombatantByName( Name )
end
--------------------------------------------------------------------------------
function TDPSMeter:IsCombatantsInCombat()
	for i, Combatant in self.FightsList[ self.Fight.Current ].CombatantsList do
		if Combatant.bCanUpdate and object.IsExist( Combatant.ID ) and object.IsInCombat( Combatant.ID ) then
			return true
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:IsEnemiesInCombat()
	for ID, Status in self.FightsList[ self.Fight.Current ].Opponents do
		if Status == enumEnemy.Attacked then
			if object.IsExist( ID ) and object.IsInCombat( ID ) then
				return true
			else
				self.FightsList[ self.Fight.Current ].Opponents[ ID ] = enumEnemy.Lost
			end
		end
	end
	return false
end
--------------------------------------------------------------------------------
function TDPSMeter:CollectCombatantsData( params )
	--       
	if not params.source or params.isFall then return end
	-- -   
	if not object.IsExist( params.source ) then return end
	--    
--	if not unit.IsFriend( params.source ) then return end

	local Variant
	local CombatantID

--
if not unit.IsFriend( params.source ) then
	LogInfo( "Damage source isnt friendly" )
end
LogInfo( "sourceName = ", params.sourceName or "???" )
LogInfo( "ability = ", params.ability or "???" )
--
LogInfo( "spellId = ", params.spellId and avatar.GetSpellInfo( params.spellId ).name or "???" )
LogInfo( "abilityId = ", params.abilityId and avatar.GetAbilityInfo( params.abilityId ).name or "???" )
LogInfo( "buffId = ", params.buffId and avatar.GetBuffInfoById( params.buffId ).name or "???" )
--
LogInfo( "" )
--
	
	--   
	if unit.IsPlayer( params.source ) or group.IsCreatureInGroup( params.source ) then
		for i, C in self.FightsList[ self.Fight.Current ].CombatantsList do
			if ( params.source == C.ID ) and ( params.target ~= C.ID ) then
				Variant = 1 -- Player or Mercenary.
				CombatantID = C.ID
				break
			end
		end

--   LightDPS

--   ( +      )
--local master = unit.GetFollowerMaster(param.source)
--if master then
--	--     ,      
--	local name = unit.IsPet(param.source) and object.GetName(param.source) or param.sourceName
--	param.ability = userMods.ToWString("["..userMods.FromWString(name).."] "..userMods.FromWString(param.ability))
--	param.source = master
--end

--

	-- , ,   ..
	elseif unit.GetFollowerMaster( params.source ) then
		local MasterID = unit.GetFollowerMaster( params.source )
		for i, C in self.FightsList[ self.Fight.Current ].CombatantsList do
			if ( MasterID == C.ID ) then
				Variant = 2 --     ...
				CombatantID = C.ID
				break
			end
		end

	--  (,  )
	elseif unit.GetRace( params.source ).creatureRace == 1 then
		for i, C in self.FightsList[ self.Fight.Current ].CombatantsList do
			if ( C.Pet ) and ( common.CompareWString( object.GetName( params.source ), C.Pet ) == 0 ) then
				Variant = 3 -- Druid's Minions.
				CombatantID = C.ID
				break
			end
		end
	end
	
	if ( not Variant ) then return end
	
	if ( not self.bCollectData ) and ( not self.FightsList[ self.Fight.Current ].Opponents[ params.target ] ) then
		self:Start()
	end
	
	self.LastHitTime = self.FightsList[ self.Fight.Current ].FightTime
	
	if params.lethal then
		self.FightsList[ self.Fight.Current ].Opponents[ params.target ] = enumEnemy.Killed
	else
		self.FightsList[ self.Fight.Current ].Opponents[ params.target ] = enumEnemy.Attacked
	end
	
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then -- Prev  
			local Combatant = self.FightsList[ FightID ]:GetCombatantByID( CombatantID )
			if Combatant then -- Crazy, in extremely rare cases it is nil.
				Combatant.DamageAmount = Combatant.DamageAmount + params.amount
			end
		end
	end
	
	if ( Variant == 1 ) then
		local SpellInfo, ID = GetSpellInfoNameFromParams( params )
		if SpellInfo then
			for _, FightID in self.Fight do
				if FightID ~= self.Fight.Prev then -- Prev  
					local Combatant = self.FightsList[ FightID ]:GetCombatantByID( CombatantID )
					if Combatant then -- Crazy, in extremely rare cases it is nil.
						local Spell = Combatant:GetSpellByIdentifier( SpellInfo.debugName, params.sysSubElement )
						if not Spell then
							local SpellName = not common.IsEmptyWString( SpellInfo.name ) and SpellInfo.name or userMods.ToWString( "?" )
							Spell = Combatant:AddNewSpell( params, SpellName )
						end
						if Spell then Spell:ReceiveValuesFromParams( params ) end
					end
				end
			end
		end
	else
		local SpellName
		if ( Variant == 2 ) then
			SpellName = userMods.ToWString( strPet .. " - " .. userMods.FromWString( params.ability ) )
		else
			SpellName = params.sourceName
		end
		for _, FightID in self.Fight do
			if FightID ~= self.Fight.Prev then -- Prev  
				local Combatant = self.FightsList[ FightID ]:GetCombatantByID( CombatantID )
				if Combatant then -- Crazy, in extremely rare cases it is nil.
					local Spell = Combatant:GetSpellByName( SpellName )
					if not Spell then
						Spell = Combatant:AddNewSpell( params, SpellName )
					end
					if Spell then Spell:ReceiveValuesFromParams( params ) end
				end
			end
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:Start()
	self:CopyFightFromCurrenToPrev()
	self:ResetFight( self.Fight.Current )

	self.OffBattleTime = false
	self.bCollectData = true
end
--------------------------------------------------------------------------------
function TDPSMeter:Stop()
	self.bCollectData = false
	self.OffBattleTime = 0
	local LagTime = self.FightsList[ self.Fight.Current ].FightTime - self.LastHitTime
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then
			self.FightsList[ FightID ].FightTime = self.FightsList[ FightID ].FightTime - LagTime
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:UpdateFightsTime()
	for _, FightID in self.Fight do
		if FightID ~= self.Fight.Prev then
			self.FightsList[ FightID ].FightTime = self.FightsList[ FightID ].FightTime + 1
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:CleanupOpponents()
	self.OffBattleTime = false
	for ID, Status in self.FightsList[ self.Fight.Current ].Opponents do
		if Status == enumEnemy.Lost then
			self.FightsList[ self.Fight.Current ].Opponents[ ID ] = nil
		end
	end
end
--------------------------------------------------------------------------------
function TDPSMeter:ResetAllFights()
	self.FightsList = {}
	self.Fight.Total = self:AddNewFight()
	self.Fight.Current = self:AddNewFight()
	self.Fight.Prev = self:AddNewFight()
end
--------------------------------------------------------------------------------
function TDPSMeter:ResetFight( ID )
	self.FightsList[ ID ].FightTime = 0
	self.FightsList[ ID ].DamageAmount = 0
	self.FightsList[ ID ].DPS = 0
	self.FightsList[ ID ].Opponents = {}
	self.FightsList[ ID ]:ClearCombatantsData()
end
--------------------------------------------------------------------------------
function TDPSMeter:CopyFightFromCurrenToPrev()
	self.FightsList[ self.Fight.Prev ] = CopyObject( self.FightsList[ self.Fight.Current ] )
end
--------------------------------------------------------------------------------
function TDPSMeter:GetPartyMembers()
	local PartyMembersInfoList
	if not raid.IsExist() then
		PartyMembersInfoList = group.GetMembers() or {}
	else
		PartyMembersInfoList = {}
		local RaidGroups = raid.GetMembers()
		local ind = 0
		for i, Group in RaidGroups do
			for i, member in Group do
				PartyMembersInfoList[ ind ] = member
				ind = ind + 1
			end
		end
	end
	return PartyMembersInfoList
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
