Global("revision", 22)	--Add`on revision
Global("srevision", 20)	--Config revision
Global("rdate", "03/11/2011")
Global("cor", nil)
Global("corhl", nil)
Global("L_units", {})
Global("L_spells", {})
Global("Fights", {})
Global("CurFight", {})

Global("V_DAMAGE", 1)
Global("V_HEAL", 2)
Global("V_DPS", 3)
Global("V_HPS", 4)

Global("TABLE_UNITS", 1)
Global("TABLE_ENEMIES", 2)
Global("TABLE_HEALERS", 3)
Global("TABLE_HEAL", 4)

Global("TABLE_UNIT_SPELLS", 11)
Global("TABLE_ENEMY_SPELLS", 12)
Global("TABLE_HEALER_SPELLS", 13)
Global("TABLE_HEAL_SPELLS", 14)

Global("REQUEST_All_UNIT_SPELLS", 21)
Global("REQUEST_All_ENEMY_SPELLS", 22)
Global("REQUEST_All_HEALER_SPELLS", 23)
Global("REQUEST_All_HEAL_SPELLS", 24)

Global("Battle", {
	cnf = {
		gropened = false,
		freeze = false,	--  
		curtable = TABLE_UNITS,
		curvis = V_DAMAGE,
		fighis = true,	-- (false) 
		grph = false
		},
	bin = false,	-- 
	dmge = false,	-- 
	ref = 0,		--.    
	tref = 0,
	avaid = 0,		--id 
	avasn = "",		--avatar system name
	dtime = 0,		--  
	fadeTime = 0,	--   
	lastp = nil	--()    
})

local cRound = 0.45
---
function GetRequest (ttype)
if ttype == "ALL" then
	if Battle.cnf.curtable == TABLE_UNITS then return REQUEST_All_UNIT_SPELLS
	elseif Battle.cnf.curtable == TABLE_ENEMIES then return REQUEST_All_ENEMY_SPELLS
	elseif Battle.cnf.curtable == TABLE_HEALERS then return REQUEST_All_HEALER_SPELLS
	elseif Battle.cnf.curtable == TABLE_HEAL then return REQUEST_All_HEAL_SPELLS
	else
	end
else
	if Battle.cnf.curtable == TABLE_UNITS then return TABLE_UNIT_SPELLS
	elseif Battle.cnf.curtable == TABLE_ENEMIES then return TABLE_ENEMY_SPELLS
	elseif Battle.cnf.curtable == TABLE_HEALERS then return TABLE_HEALER_SPELLS
	elseif Battle.cnf.curtable == TABLE_HEAL then return TABLE_HEAL_SPELLS
	else
	end
end
end

function GetTblData (tbl_type,number)
local tbl = {}
if tbl_type == TABLE_UNITS then
	tbl = Fights[number].db[TABLE_UNITS]
	if tbl then return tbl.tUnits, tbl.amount, Fights[number].ftime end
elseif tbl_type == TABLE_ENEMIES then
	tbl = Fights[number].db[TABLE_ENEMIES]
	if tbl then return tbl.tUnits, tbl.amount, Fights[number].ftime end
elseif tbl_type == TABLE_HEALERS then
	tbl = Fights[number].db[TABLE_HEALERS]
	if tbl then return tbl.tUnits, tbl.amount, Fights[number].ftime end
elseif tbl_type == TABLE_HEAL then
	tbl = Fights[number].db[TABLE_HEAL]
	if tbl then return tbl.tUnits, tbl.amount, Fights[number].ftime end
elseif tbl_type == TABLE_UNIT_SPELLS then
	tbl = Fights[LastFght].db[TABLE_UNITS].tUnits[number]
	if tbl then return tbl.tSpells, tbl.amount end
elseif tbl_type == TABLE_ENEMY_SPELLS then
	tbl = Fights[LastFght].db[TABLE_ENEMIES].tUnits[number]
	if tbl then return tbl.tSpells, tbl.amount end
elseif tbl_type == TABLE_HEALER_SPELLS then
	tbl = Fights[LastFght].db[TABLE_HEALERS].tUnits[number]
	if tbl then return tbl.tSpells, tbl.amount end
elseif tbl_type == TABLE_HEAL_SPELLS then
	tbl = Fights[LastFght].db[TABLE_HEAL].tUnits[number]
	if tbl then return tbl.tSpells, tbl.amount end
	
elseif tbl_type == REQUEST_All_UNIT_SPELLS then
	return GetAllUnSpells(TABLE_UNITS, number)
elseif tbl_type == REQUEST_All_ENEMY_SPELLS then
	return GetAllUnSpells(TABLE_ENEMIES, number)
elseif tbl_type == REQUEST_All_HEALER_SPELLS then
	return GetAllUnSpells(TABLE_HEALERS, number)
elseif tbl_type == REQUEST_All_HEAL_SPELLS then
	return GetAllUnSpells(TABLE_HEAL, number)
else
	return GetAllUnSpells(TABLE_HEALERS, number)
end
end

local function CompSType (t1, t2)
return t1.sysActionSourceType == t2.sysActionSourceType and
	t1.sysSubElement == t2.sysSubElement and
	common.CompareWString(t1.ability, t2.ability) == 0
end

local function GetAbSub (a)
if a.spellId then
	return avatar.GetSpellInfo(a.spellId).name, avatar.GetSpellInfo(a.spellId).sysSubElement
elseif a.abilityId then
	return avatar.GetAbilityInfo(a.abilityId).name, "ENUM_SubElement_HOLY"
elseif a.buffId then
	return avatar.GetBuffInfoById(a.buffId).name, "ENUM_SubElement_HOLY"
else
	return common.GetEmptyWString(), "ENUM_SubElement_HOLY"
end
end

local function FindName (name)
if L_units and name then
	for v,t in L_units do
		if name == t.usName then return v end
	end
end
return 0
end

local function FindSpell (s)
for v,t in L_spells do
	if (t.source == s.sysActionSourceType) and
	(t.sColor == s.sysSubElement) and
	(common.CompareWString(t.sName, s.ability) == 0) then return v end
end
return 0
end

local function AddUSpell (tbl, DRSpell)
local tspell = {
	ability = nil,
	sysSubElement = "",
	sysActionSourceType = "",
	sAmount = 0,
	cnt = 0,
	cntcrit = 0,
	cntglans = 0,
	cntmiss = 0,
	cntdodge = 0,
	maxAm = 0,
	minAm = 1e8,
	shieldBlock = 0,
	parry = 0,
	resist = 0,
	absorb = 0
}
local pos
tspell.sysActionSourceType = DRSpell.sysActionSourceType


if DRSpell.ability then
	tspell.ability = DRSpell.ability
	tspell.sysSubElement = DRSpell.sysSubElement
else
	--[[if DRSpell.absorbed ~=0 then
		common.LogInfo(common.GetAddonName(),"absorbed(!!!): ",common.FormatInt(DRSpell.absorbed, "%d"), " heal: ", common.FormatInt(DRSpell.heal,"%d")," resisted: ", common.FormatInt(DRSpell.resisted,"%d")," healthLevel: ", common.FormatInt(DRSpell.healthLevel,"%d"), " - ", object.GetName(DRSpell.unitId))
	end]]

	tspell.ability, tspell.sysSubElement = GetAbSub (DRSpell)
	if DRSpell.healthLevel < 100 then
		DRSpell.resist = DRSpell.resisted + (DRSpell.runeResisted and DRSpell.runeResisted or 0)
		DRSpell.absorb = DRSpell.absorbed
		DRSpell.parry = 0
		DRSpell.shieldBlock = 1

		
	else
		DRSpell.resist = 0
		DRSpell.absorb = 0
		DRSpell.parry = DRSpell.heal
		DRSpell.shieldBlock = 0
	end
	DRSpell.amount = DRSpell.heal
end

if tbl[1].ability then
	for v,t in tbl do
		if CompSType(tspell, t) then
			tspell = t
			pos = v
			break
		end
	end
else
	table.remove(tbl)
end

--userMods.SetGlobalConfigSection("DRSpell"..DRSpell.amount, DRSpell)
--[[common.LogInfo(common.GetAddonName(),DRSpell.ability, " - ability - ", tspell.ability, " amount - ", common.FormatInt( DRSpell.amount,"%d"))
common.LogInfo(common.GetAddonName(),DRSpell.sysActionSourceType ," - sysActionSourceType - ", tspell.sysActionSourceType)
common.LogInfo(common.GetAddonName(),DRSpell.sysSubElement ," - sysSubElement - ", tspell.sysSubElement)]]


tspell.cnt = tspell.cnt + 1
if DRSpell.isMiss then tspell.cntmiss = tspell.cntmiss + 1
elseif DRSpell.isDodge then tspell.cntdodge = tspell.cntdodge + 1
else
	tspell.sAmount = tspell.sAmount + DRSpell.amount
	tspell.shieldBlock = tspell.shieldBlock + DRSpell.shieldBlock
	tspell.parry = tspell.parry + DRSpell.parry
	tspell.resist = tspell.resist + DRSpell.resist
	tspell.absorb = tspell.absorb + DRSpell.absorb
	if DRSpell.isCritical then
		tspell.cntcrit = tspell.cntcrit + 1
	elseif DRSpell.isGlancing then
		tspell.cntglans = tspell.cntglans + 1
	end
end
if tspell.maxAm < DRSpell.amount then tspell.maxAm = DRSpell.amount end
if tspell.minAm > DRSpell.amount then tspell.minAm = DRSpell.amount end
if pos then tbl[pos] = tspell
else table.insert(tbl, tspell)
end
return tbl
end

local function InsertTbl (tbl)
local tb = {}
for v,t in tbl do
	tb[v] = {}
	tb[v].amount = t.amount
	tb[v].utime = t.etime - t.btime
	if t.mastername then t.name = t.PandM end
	tb[v].myid = Addlunit(t.name,t.uColor)
	tb[v].tSpells = {{}}
	for u,p in t.tSpells do
		tb[v].tSpells = AddUSpell (tb[v].tSpells, p)
	end
	for u, p in tb[v].tSpells do
		tb[v].tSpells[u].myid = Addlspell(p)
	end
end
return tb
end

function InsertFightHls ()
local CF = CurFight.db[TABLE_HEALERS]
if not CF then return end
CF = CF.tUnits
local pos = 1
while CF[pos] do
	if CF[pos].amount > 0 then pos = pos + 1
	else table.remove(CF, pos)
	end
end

if CF[2] then
	table.sort(CF, function(a, b) return a.amount > b.amount end)
end
Fights[1].db[TABLE_HEALERS].tUnits = InsertTbl (CF)
Fights[1].db[TABLE_HEALERS].amount = CurFight.db[TABLE_HEALERS].amount
end

function InsertFightE (tbl_type)
local pos1, pos2 = 1, 1
local CF = CurFight.db[tbl_type]
if not CF then return end
CF = CF.tUnits
if CF[2] then
	while CF[pos1] do
		pos2 = pos1 + 1
		while CF[pos2] do
			if (CF[pos1].player == CF[pos2].player) and (CF[pos1].sysname == CF[pos2].sysname) then
			--if CF[pos1].sysname == CF[pos2].sysname then
				CF[pos1].amount = CF[pos1].amount + CF[pos2].amount
				for v, t in CF[pos2].tSpells do
					table.insert(CF[pos1].tSpells, t)
				end
				table.remove(CF,pos2)
			else
				pos2 = pos2 + 1
			end
		end
		pos1 = pos1 + 1
	end
	table.sort(CF, function(a, b) return a.amount > b.amount end)
end
Fights[1].db[tbl_type].tUnits = InsertTbl (CF)
Fights[1].db[tbl_type].amount = CurFight.db[tbl_type].amount
end

function InsertFight ()
--common.LogInfo("","InsertFight0 ",tostring(CurFight.ftime))
--if CurFight.fName and CurFight.ftime > 0 then
if CurFight.fName then
	AddUT(nil, 0, true)
	local ts
	local pos = 1
	local CF = CurFight.db[TABLE_UNITS].tUnits
	while Fights[MaxHistory] do table.remove(Fights) end
	if MasterAndPet then
		pos = 1
		while CF[pos] do
			if CF[pos].mastername then
				for v,t in CF do
					if (CF[pos].sysmn == t.sysname) then
						t.name = CF[pos].MandP
						t.amount = t.amount + CF[pos].amount
						if t.btime and CF[pos].btime then
							t.btime = (t.btime < CF[pos].btime) and t.btime or CF[pos].btime
							t.etime = (t.etime > CF[pos].etime) and t.etime or CF[pos].etime
						else
							t.btime = CF[pos].btime and CF[pos].btime or t.btime
							t.etime = CF[pos].etime and CF[pos].etime or t.etime
						end
						for u, p in CF[pos].tSpells do
							p.ability = userMods.ToWString(userMods.FromWString(p.ability ).." <"..userMods.FromWString(CF[pos].name)..">")
							table.insert(t.tSpells,p)
						end
						table.remove(CF, pos)
						break
					end
				end
			else pos = pos + 1
			end
		end
	end
	pos = 1
	while CF[pos] do
		if CF[pos].amount > 0 then pos = pos + 1
		else table.remove(CF, pos)
		end
	end
	if CF[2] then
		table.sort(CF, function(a, b) return a.amount > b.amount end)
	end
	
	local lfghts = {}
	lfghts.fName = CurFight.fName
	lfghts.ftime = CurFight.db[TABLE_UNITS].etime - CurFight.db[TABLE_UNITS].btime
	--lfghts.ftime = CurFight.ftime
	--CurFight.ftime = lfghts.ftime
	lfghts.ftime_unit = CurFight.ftime_unit
	lfghts.db = {}
	lfghts.db[TABLE_UNITS] = {amount = CurFight.db[TABLE_UNITS].amount, tUnits = {}}
	lfghts.db[TABLE_UNITS].tUnits = InsertTbl (CF)
	
	for i=7,8 do
		lfghts.ftime_unit[i] = Addlunit(lfghts.ftime_unit[i])
	end
	table.insert(Fights, 1, lfghts)
	for i=TABLE_ENEMIES, TABLE_HEAL do
		Fights[1].db[i] = {amount = 0, tUnits = {}}
	end
	return true
end
end

function GetMinSec (mcsec)
local lmin = math.floor((mcsec + cRound * 1e3) / 6e4)
return lmin, mcsec / 1e3 - lmin * 60 + cRound
end

function Format02d(num)
return userMods.ToWString(string.format('%.2d',num))
end

function Format45d(num)
local nm = math.abs(num)
if nm < 10 then return userMods.ToWString(string.format('%.2f',num))	--0.00 - 9.99
elseif nm < 1e3 then return userMods.ToWString(string.format('%.1f',num))	--10.0 - 999.9
elseif nm < 1e4 then return userMods.ToWString(string.format('%d',num))	--1000 - 9999
elseif nm < 1e5 then return userMods.ToWString(string.format('%.1f',num/1e3).."k")	--10.0k - 99.9k
elseif nm < 1e6 then return userMods.ToWString(string.format('%d',num/1e3).."K")	--100K - 999K
elseif nm < 1e8 then return userMods.ToWString(string.format('%.1f',num/1e6).."M")	--1.0M - 99.9M
elseif nm < 1e9 then return userMods.ToWString(string.format('%d',num/1e6).."M")	--100M - 999M
elseif nm < 1e11 then return userMods.ToWString(string.format('%.1f',num/1e9).."G")	--1.0G - 99.9G
else return userMods.ToWString(string.format('%d',num/1e9).."G")	-- > 100G
end
end

function Addlunit (name, color)
if not L_units then L_units = {} end
local nm = userMods.FromWString(name)
local pos = FindName (nm)
if pos > 0 then
	if not L_units[pos].uColor then L_units[pos].uColor = color end
	return pos
else
	table.insert(L_units, {usName = nm, uName = name, uColor = color})
	return table.getn(L_units)
end
end

function Addlspell (DRSpell)
if not L_spells then L_spells = {} end
local pos = FindSpell (DRSpell)
if pos > 0 then return pos
else
	table.insert(L_spells, {sName = DRSpell.ability,
							source = DRSpell.sysActionSourceType,
							sColor = DRSpell.sysSubElement})
	return table.getn(L_spells)
end
end

function StartFigth ()
local nl = common.GetEmptyWString()
CurFight = {
	fName = nil,
	--fQuality = UNIT_QUALITY_COMMON,
	ftime = 0,
	ftime = 0,
	ftime_unit = {0,0,0,0,0,0,nl,nl,nl,nl},
	db = {}
}
AddUnits ()
Battle.ref = VRefresh
Battle.tref = TRefresh


local function SetData (table_tp, a, nl)
	table.insert(CurFight.db[table_tp].tUnits[nl].tSpells, a)
	CurFight.db[table_tp].amount = CurFight.db[table_tp].amount + a.amount
	CurFight.db[table_tp].tUnits[nl].amount = CurFight.db[table_tp].tUnits[nl].amount + a.amount
	if not CurFight.db[table_tp].btime then
		CurFight.db[table_tp].btime = CurFight.ftime
	end
	CurFight.db[table_tp].etime = CurFight.ftime + 1e3
	if not CurFight.db[table_tp].tUnits[nl].btime then
		CurFight.db[table_tp].tUnits[nl].btime = CurFight.ftime
	end
	CurFight.db[table_tp].tUnits[nl].etime = CurFight.ftime + 1e3
	
	--[[common.LogInfo("","btime0 = ", tostring(CurFight.db[table_tp].btime))
	common.LogInfo("","etime0 = ", tostring(CurFight.db[table_tp].etime))
	
	common.LogInfo("","btime = ", tostring(CurFight.db[table_tp].tUnits[nl].btime))
	common.LogInfo("","etime = ", tostring(CurFight.db[table_tp].tUnits[nl].etime))]]
end

cor = coroutine.create(function (a)
while true do
	nl = CheckSource (a)
	if nl > 0 then
		SetData(TABLE_UNITS, a, nl)
		Battle.dmge = true
		Battle.dtime = CurFight.ftime
		AddUT(a.ability, nl)
	elseif nl < 0 then
		SetData(TABLE_ENEMIES, a, AddUnindb (TABLE_ENEMIES, a.source))
	end
	a = coroutine.yield ()
	if not a then break end
end
--Battle.inbuild = false
--SaveFightincfg()
--common.LogInfo("","InsertFight1")
if InsertFight () then
	--common.LogInfo("","InsertFight2")
	InsertFightE (TABLE_ENEMIES)
	--common.LogInfo("","InsertFight3")
	InsertFightHls ()
	--common.LogInfo("","InsertFight4")
	InsertFightE (TABLE_HEAL)
	--common.LogInfo("","InsertFight5")
	--SaveFightincfg()
end
--common.LogInfo("","InsertFight6")
for _,t in CurFight.db do for __,p in t.tUnits do p.tSpells = {} end end
--common.LogInfo("","InsertFight7")
--Battle.inbuild = false
end
)

corhl = coroutine.create(function (a)
while true do
	nl = CheckSource(a)
	a.amount = a.heal
	if nl < 0 then
		--    +   
		SetData(TABLE_HEALERS, a, -nl)
		SetData(TABLE_HEAL, a, AddUnindb (TABLE_HEAL, a.healerId))
	elseif nl > 99 then
		--    
		SetData(TABLE_HEAL, a, AddUnindb (TABLE_HEAL, a.healerId))
	elseif nl > 0 then
		--    
		SetData(TABLE_HEALERS, a, nl)
	end
	a = coroutine.yield ()
	if not a then break end
end
end
)
--[[local cnt,cnt2 = gcinfo()
--common.LogInfo(common.GetAddonName(),"gcinfo() - ", common.FormatInt(cnt,"%d"),"/", common.FormatInt(cnt2,"%d"))
if cnt > 410 * MaxHistory then collectgarbage() common.LogInfo(common.GetAddonName(),"collectgarbage() - ") end]]
end

function AddUnindb (dbnum, id)
local nm = object.GetName(id)
local snm, pl = userMods.FromWString(nm), unit.IsPlayer(id)
if not CurFight.db[dbnum] then
	CurFight.db[dbnum] = {amount = 0, tUnits = {}}
else
	for v,t in CurFight.db[dbnum].tUnits do
		if t.sysname == snm and t.player == pl then return v end
	end
end
local tun = {
	player = pl,		--key field (bool)
	sysname = snm,	--key field(string)
	name = nm,		--WString
	--id = id,
	uColor = nil,
	amount = 0,
	tSpells = {}
}
if unit.IsPlayer(id) then
	tun.uColor = GetColor(unit.GetClass(id).className)
elseif unit.GetRace(id) then
	tun.uColor = GetColor(unit.GetRace(id).sysCreatureRace)
else
	tun.uColor = GetColor("")
end
table.insert(CurFight.db[dbnum].tUnits, tun)
return table.getn(CurFight.db[dbnum].tUnits)
end

function AddCurUnit (name, id, mastername)
if not id then return end
local snm, pl = userMods.FromWString(name), id and unit.IsPlayer(id) or false
local tun = {
	player = pl,		--key field (bool)
	sysname = snm,	--key field(string)
	name = name,
	--id = id,
	uColor = nil,
	mastername = mastername,
	sysmn = snm,
	MandP = mastername,
	PandM = name,
	amount = 0,
	tSpells = {}
}
if mastername then
	tun.MandP = userMods.ToWString(userMods.FromWString(mastername).."<"..tun.sysname..">")
	tun.PandM = userMods.ToWString(tun.sysname.."<"..userMods.FromWString(mastername)..">")
	tun.sysmn = userMods.FromWString(tun.mastername)
end

if unit.IsPlayer(id) then
	tun.uColor = GetColor(unit.GetClass(id).className)
elseif id and unit.GetRace(id) then
	tun.uColor = GetColor(unit.GetRace(id).sysCreatureRace)
else
	tun.uColor = GetColor("")
end
table.insert(CurFight.db[TABLE_UNITS].tUnits, tun)
end

function IF ()
coroutine.resume(corhl)
coroutine.resume(cor)
--common.LogInfo(common.GetAddonName(),coroutine.status(corhl))
end

function AddUT(spl, uin, setim, babeg)
if setim then 
	local tme = mission.GetWorldTimeHMS()
	if babeg then
		CurFight.ftime_unit[1] = tme.h
		CurFight.ftime_unit[2] = tme.m
		CurFight.ftime_unit[3] = tme.s
		CurFight.ftime_unit[9] = spl
		if CurFight.db[TABLE_UNITS].tUnits[uin].mastername then
			CurFight.ftime_unit[7] = CurFight.db[TABLE_UNITS].tUnits[uin].PandM
		else
			CurFight.ftime_unit[7] = CurFight.db[TABLE_UNITS].tUnits[uin].name
		end
	else
		CurFight.ftime_unit[4] = tme.h
			CurFight.ftime_unit[5] = tme.m
			CurFight.ftime_unit[6] = tme.s
	end
elseif CurFight.db[TABLE_UNITS].tUnits[uin].mastername then
	CurFight.ftime_unit[8] = CurFight.db[TABLE_UNITS].tUnits[uin].PandM
	CurFight.ftime_unit[10] = spl
else
	CurFight.ftime_unit[8] = CurFight.db[TABLE_UNITS].tUnits[uin].name
	CurFight.ftime_unit[10] = spl
end
end

function Resetdata ()
L_units = {}
L_spells = {}
Fights = {}
Battle.bin = false
Battle.dmge = false
Battle.lastp = {}
--Battle.ref = 0
--Battle.tref = 0
--Battle.checkout = 0
StartFigth ()
RefrVisData ()
end

function addtestunits()
local grp = avatar.GetUnitList()
local tbl = {}
local pos = 1
for v, t in grp do
	if pos > 23 then break end
	--if unit.IsPlayer(t) or unit.IsPet(t) then
	if unit.IsPlayer(t) then
		tbl[pos] = {
			name = object.GetName(t),
			id = t
		}
		pos = pos +1 
	end
end
grp = avatar.GetId()
tbl[pos] = {
		name = object.GetName(grp),
		id = grp
}
return tbl
end

function AddUnits ()
--common.LogInfo("","AddUnits ")
local grp, owner = group.GetMembers()
for i=TABLE_UNITS, TABLE_HEAL do
	CurFight.db[i] = {amount = 0, tUnits = {}, lamount = 0, DPS = {}, MiAMx = {1e9,0,1}}
end
--local grp = addtestunits()		--for test
if raid.IsExist() then
	grp = raid.GetMembers()
	for v,t in grp do
		for u,p in t do
			AddCurUnit (p.name, p.id)
		end
	end
	grp = avatar.GetUnitList()
	for v,t in grp do
		if unit.IsPet(t) then
			owner = unit.GetPetOwner(t)
			owner = owner and userMods.FromWString(object.GetName(owner))
			for u,p in CurFight.db[TABLE_UNITS].tUnits do
				if p.sysname == owner then AddCurUnit (object.GetName(t), t, p.name) break end
			end
		end
	end
elseif grp then
	for v,t in grp do
		AddCurUnit (t.name, t.id)
		if t.id and unit.GetActivePet(t.id) then
			AddCurUnit (object.GetName(unit.GetActivePet(t.id)), unit.GetActivePet(t.id), t.name)
		end
	end
	
	---for test//
	--[[grp = avatar.GetUnitList()
	for v,t in grp do
		if unit.IsPet(t) then
			owner = unit.GetPetOwner(t)
			owner = owner and userMods.FromWString(object.GetName(owner))
			for u,p in CurFight.db[TABLE_UNITS].tUnits do
				if p.sysname == owner then AddCurUnit (object.GetName(t), t, p.name) break end
			end
		end
	end]]
	--//for test
else
	grp = avatar.GetId()
	AddCurUnit (object.GetName(grp), grp)
	if unit.GetActivePet(grp) then
		AddCurUnit (object.GetName(unit.GetActivePet(grp)), unit.GetActivePet(grp), object.GetName(grp))
	end
end
grp = CurFight.db[TABLE_HEALERS]
owner = 1
for v,t in CurFight.db[TABLE_UNITS].tUnits do
	if t.player then 
		grp.tUnits[owner] = {
			player = t.player,		--key field (bool)
			sysname = t.sysname,	--key field(string)
			name = t.name,		--WString
			--id = t.id,		--delete it
			uColor = t.uColor,
			amount = 0,
			tSpells = {}
		}
		owner = owner + 1
	end
end
--common.LogInfo(common.GetAddonName(),"tUnits ",common.FormatInt(table.getn(CurFight.tUnits),"%d"))
end

function CheckSource (param)
if param.source then 
	--   
	if not object.IsExist(param.source)then return 0 end
	-- 
	if param.target == Battle.avaid then return -1 end
	--   +  
	if param.target == param.source or (param.sysSubElement == "ENUM_SubElement_PHYSICAL" and userMods.FromWString(param.ability) == "") then return 0 end
	
	local nme, pt, po = userMods.FromWString(object.GetName(param.source)), unit.IsPet(param.source), ""
	if pt then
		po = unit.GetPetOwner(param.source)
		po = po and userMods.FromWString(object.GetName(po)) or ""
		nme = po..nme
	end
	
	for v,t in CurFight.db[TABLE_UNITS].tUnits do
		if nme == ((pt and t.sysmn or "")..t.sysname) then
			if not CurFight.fName and object.IsExist(param.target) then
				CurFight.ftime = 0
				--CurFight.fQuality = unit.GetQuality(param.target)
				CurFight.fName = object.GetName(param.target)
				AddUT(param.ability, v, true, true)
			end
			--[[if param.lethal then
				common.LogInfo("",param.ability, " param.lethal ", tostring(param.amount))
			end]]
			return v
		end
	end
elseif param.healerId then
	if not param.unitId or unit.IsPet(param.healerId) then return 0 end
	local nme, pl = userMods.FromWString(object.GetName(param.healerId)), unit.IsPlayer(param.healerId)
	for v,t in CurFight.db[TABLE_HEALERS].tUnits do
		if nme == t.sysname then
			if param.unitId == Battle.avaid then return -v
			else return v
			end
		end
	end
end
return 0
end

function AddData (DRSpell)
if DRSpell.source then
	coroutine.resume(cor, DRSpell)
else
	coroutine.resume(corhl, DRSpell)
end
--common.LogInfo(common.GetAddonName(),coroutine.status(cor)," ",coroutine.status(corhl))
end

function AddTickDPS(lst)
local db = CurFight.db[TABLE_UNITS]
local amt = db.amount - db.lamount
if db.DPS[1] or amt>0 then
	table.insert(db.DPS,1,amt)
	db.lamount = db.amount
end
db = CurFight.db[TABLE_HEALERS]
amt = db.amount - db.lamount
if db.DPS[1] or amt>0 then
	table.insert(db.DPS,1,amt)
	db.lamount = db.amount
end
end

function GetCurDPS()
local db = (Battle.cnf.curvis == V_DAMAGE or Battle.cnf.curvis == V_DPS) and CurFight.db[TABLE_UNITS] or CurFight.db[TABLE_HEALERS]
local tm = db.btime and (db.etime - db.btime) or 1e3
local tbl = {
	db.amount,
	tm > 0  and (1e3 * db.amount / tm) or db.amount
}
tbl[3], tbl[4] = GetMinSec(CurFight.ftime)
if Battle.cnf.curvis == V_HPS or Battle.cnf.curvis == V_DPS then
	tbl[1], tbl[2] = tbl[2], tbl[1]
end
return tbl
end

function GetCurGroupDPS()
local tbl, maxpr = {}, 0
local pos = 1
local db = (Battle.cnf.curvis == V_DAMAGE or Battle.cnf.curvis == V_DPS) and CurFight.db[TABLE_UNITS] or CurFight.db[TABLE_HEALERS]
if MasterAndPet then
	for v,t in db.tUnits do
		if not t.mastername then
			tbl[pos] = {
				t.sysname,
				t.amount,
				t.name,
				t.uColor,
				t.btime and (t.etime - t.btime) or 1e3
			}
			pos = pos + 1
		end
	end
	for v,t in db.tUnits do
		if t.mastername then
			for u,p in tbl do
				if t.sysmn == p[1] then
					p[2] = p[2] + t.amount
					p[3] = t.MandP
					if t.btime then
						if p[5] < (t.etime - t.btime) then p[5] = t.etime - t.btime end
					end
					break
				end
			end
		end
	end
else
	for v,t in db.tUnits do
		tbl[v] = {
			t.sysname,
			t.amount,
			t.mastername and t.PandM or t.name,
			t.uColor,
			t.btime and (t.etime - t.btime) or 1e3
		}
	end
end

--[[pos = 1
while tbl[pos] do
	if tbl[pos][2] > 0 then pos = pos +1
	else table.remove(tbl,pos) end
end]]

for v,t in tbl do
	t[5] = (t[5] > 0) and (1e3 * t[2] / t[5]) or t[2]
	if Battle.cnf.curvis == V_HPS or Battle.cnf.curvis == V_DPS then
		t[2], t[5] = t[5], t[2]
	end
end

if tbl[2] then table.sort(tbl, function(a, b) return a[2] > b[2] end) end

--[[if Battle.cnf.curvis == V_HPS or Battle.cnf.curvis == V_DPS then
	maxpr = tbl[1] and tbl[1][2] or 0
else
	maxpr = db.amount
end]]
return tbl--, maxpr
end

function GetGroupDPS(tbl_type,fnum)
local tbl, ttbl, dam, tim = {}, {}
ttbl, dam, tim = GetTblData (tbl_type,fnum)
if not ttbl then return tbl end
for v,t in ttbl do
	tbl[v] = {
		L_units[t.myid].uName,
		t.amount,
		L_units[t.myid].uName,
		L_units[t.myid].uColor,
		t.utime and (1e3 * t.amount / t.utime) or t.amount,
		(dam > 0) and (cRound + 100 * t.amount / dam) or 0
		
	}
end
return tbl
end

function GetUnitSpells(tbl_type,unum)
local tbl, unt, dam = {}, {}
local pos = 1
unt, dam = GetTblData (tbl_type,unum)
if not unt then return tbl end
for v,t in unt do
	tbl[v] = {}
	tbl[v][1] = t.sAmount
	tbl[v][2] = L_spells[t.myid].sName
	if string.find(L_spells[t.myid].source, "Dot") then
		tbl[v][2] = userMods.ToWString("*".. userMods.FromWString(tbl[v][2]))
	end
	tbl[v][3] = GetColor(L_spells[t.myid].sColor)
	tbl[v][4] = dam > 0 and (cRound + 100 * tbl[v][1] / dam) or 0
	tbl[v][5] = t.cnt
	tbl[v][6] = t.maxAm
	tbl[v][7] = t.sAmount / t.cnt
	tbl[v][8] = t.minAm < 1e8 and t.minAm or 0
	tbl[v][9] = cRound + 100 * t.cntcrit / t.cnt
	tbl[v][10] = cRound + 100 * t.cntglans / t.cnt
	tbl[v][11] = t.cntmiss
	tbl[v][12] = t.cntdodge
	tbl[v][13] = t.shieldBlock
	tbl[v][14] = t.parry
	tbl[v][15] = t.resist
	tbl[v][16] = t.absorb
	if math.mod(tbl_type, 10) < TABLE_HEALERS then
		tbl[v][17] = t.shieldBlock + t.parry + t.resist + t.absorb
		tbl[v][18] = t.sAmount + tbl[v][17]
		
	else
		tbl[v][17] = t.resist + t.absorb
		tbl[v][18] = t.sAmount - t.parry + tbl[v][17]
		if t.shieldBlock > 0 then
			tbl[v][7] = (t.sAmount - t.parry) / t.shieldBlock
		end
	end
	tbl[v][18] = tbl[v][18] > 0 and (cRound + 100 * tbl[v][17] / tbl[v][18]) or 0
end

if tbl[2] then
	table.sort(tbl, function(a, b) return a[1] > b[1] end)
end
return tbl
end

function GetAllUnits (tbl_type)
local tbl = {}
local pos = 1
if not tbl_type then return tbl end
local tb = {}
local function findunit(myid)
	for v,t in tbl do
		if t[1] == myid then return v end
	end
return 0
end
for v,t in Fights do
	for u,p in t.db[tbl_type].tUnits do
		pos = findunit(p.myid)
		if pos > 0 then tb = tbl[pos]
		else
			tb = {0,0,0}
			tb[1] = p.myid
		end
		tb[2] = tb[2] + p.amount
		tb[3] = tb[3] + t.ftime
		tb[4] = L_units[p.myid].uColor
		if pos > 0 then tbl[pos] = tb
		else table.insert(tbl,tb) end
	end
end

if tbl[2] then
	table.sort(tbl, function(a, b) return a[2] > b[2] end)
end
for v,t in tbl do
	t[5] = 1e3 * t[2] / t[3]
	t[6], t[7] = GetMinSec(t[3])
	t[1], t[3] = L_units[t[1]].uName, t[1]
end
return tbl
end

function GetAllUnSpells (tbl_type, unid)
local tbl, tb = {}
local pos, dam = 0, 0

local function finds(sid)
	for v,t in tbl do
		if t.myid == sid then return v end
	end
return 0
end
--common.LogInfo(common.GetAddonName(),"GetAllUnSpells - tbl_type ",Format02d(tbl_type))
for v,t in Fights do
	for u,p in t.db[tbl_type].tUnits do
		if p.myid == unid then
			for n,m in p.tSpells do
				pos = finds(m.myid)
				if pos < 1 then
					pos = table.getn(tbl)+1
					tbl[pos] = {}
					tbl[pos].myid = m.myid
					tbl[pos].sAmount = 0
					tbl[pos].cnt = 0
					tbl[pos].cntcrit = 0
					tbl[pos].cntglans = 0
					tbl[pos].cntmiss = 0
					tbl[pos].cntdodge = 0
					tbl[pos].maxAm = 0
					tbl[pos].minAm = 1e8
					tbl[pos].shieldBlock = 0
					tbl[pos].parry = 0
					tbl[pos].resist = 0
					tbl[pos].absorb = 0
				end
				tbl[pos].sAmount = tbl[pos].sAmount + m.sAmount
				tbl[pos].cnt = tbl[pos].cnt + m.cnt
				tbl[pos].cntcrit = tbl[pos].cntcrit + m.cntcrit
				tbl[pos].cntglans = tbl[pos].cntglans + m.cntglans
				tbl[pos].cntmiss = tbl[pos].cntmiss + m.cntmiss
				tbl[pos].cntdodge = tbl[pos].cntdodge + m.cntdodge
				
				tbl[pos].shieldBlock = tbl[pos].shieldBlock + m.shieldBlock
				tbl[pos].parry = tbl[pos].parry + m.parry
				tbl[pos].resist = tbl[pos].resist + m.resist
				tbl[pos].absorb = tbl[pos].absorb + m.absorb
				if tbl[pos].maxAm < m.maxAm then tbl[pos].maxAm = m.maxAm end
				if tbl[pos].minAm > m.minAm then tbl[pos].minAm = m.minAm end
			end
			dam = dam + p.amount
			break
		end
	end
end
return tbl, dam
end

function GetAllUnFights (tbl_type, unid)
local tbl, pos = {}, 1
for v,t in Fights do
	for u,p in t.db[tbl_type].tUnits do
		if p.myid == unid then
			tbl[pos] = {
				t.fName,
				p.amount,
				t.ftime,
				p.utime and (1e3 * p.amount / p.utime) or p.amount
			}
			pos = pos + 1
			break
		end
	end
end
return tbl
end

function GetFights (tbl_type)
local tbl = {}
for v,t in Fights do
	tbl[v] = {
		t.fName,
		t.db[tbl_type].amount,
		t.ftime,
		t.ftime and (1e3 * t.db[tbl_type].amount / t.ftime) or t.db[tbl_type].amount
	}
end
return tbl
end