--Created By Valltron 21.02.2010 13:46
--Patched By EsAlexey 21.06.2010 20:02
--update by icreator 2011/09/10

--------------------------------------------------------------------------------
-- EVENT HANDLERS
--------------------------------------------------------------------------------

--      ,         :
function OnVendorListUpdated()
	local currentBagSize = avatar.InventoryGetBaseBagSlotCount()
	for slotIndex = 0, currentBagSize - 1 do
		local itemId = avatar.GetInventoryItemId( slotIndex )
		if itemId then
			local itemInfo = avatar.GetItemInfo( itemId )
			if itemInfo.quality == ITEM_QUALITY_JUNK then
				if avatar.Sell then avatar.Sell( slotIndex, itemInfo.stackCount )
				elseif avatar.SellItemToVendor then avatar.SellItemToVendor( itemId )
				end
			end
		end
	end
	--    ,       :
	common.UnRegisterEventHandler(OnVendorListUpdated, "EVENT_VENDOR_LIST_UPDATED")
end

--     NPC,    :
function OnTalkStarted()
	--          :
	common.RegisterEventHandler(OnVendorListUpdated, "EVENT_VENDOR_LIST_UPDATED")
end

--     NPC,    :
function OnTalkStopped()
	--          ,   :
	common.UnRegisterEventHandler(OnVendorListUpdated, "EVENT_VENDOR_LIST_UPDATED")
end

--------------------------------------------------------------------------------
-- INITIALIZATION
--------------------------------------------------------------------------------
function Init()
	-- :
	common.RegisterEventHandler(OnTalkStarted, "EVENT_TALK_STARTED")
	common.RegisterEventHandler(OnTalkStopped, "EVENT_TALK_STOPPED")
end
--------------------------------------------------------------------------------
Init()
--------------------------------------------------------------------------------