Global("wtMainPanel",           nil)
Global("wtPlayerList_Name",     nil)
Global("wtPlayerList_Level",    nil)
Global("wtPlayerList_Health",   nil)
Global("wtButtonSelector",      nil)
Global( "wtTotHealth", nil )

Global("wtPlayerList_Names",    {})
Global("wtPlayerList_Levels",   {})
Global("wtPlayerList_Healths",  {})
Global("wtButtonSelectors",     {})
Global( "wtTotHealths", {})

Global("wtMainPanelDNDId",      834)

Global("unitList",  {})
Global("unitCount", 0)

Global("bExecLock", false)
Global("bUIToggleVisible", true)

Global('PLAYERLIST_MAX_ROWS',           7)
Global('PLAYERLIST_ROW_HEIGHT',         20)

Global('PLAYERLIST_PRIORITY_FLAGGED',   100)
Global('PLAYERLIST_PRIORITY_CLASSES',   {
	["DRUID"]         = 100,
	["MAGE"]          = 100,
	["NECROMANCER"]   = 100,
	["PALADIN"]       = 100,
	["PRIEST"]        = 105,
	["PSIONIC"]       = 100,
	["STALKER"]       = 100,
	["WARRIOR"]       = 100,
	["BARD"]          = 100
})

Global("ClassColors", {
	["WARRIOR"]		= { r = 0.65; g = 0.54; b = 0.34; a = 1 },
	["PALADIN"]		= { r = 0.00; g = 0.88; b = 0.78; a = 1 },
	["MAGE"]		= { r = 0.18; g = 0.57; b = 1.00; a = 1 },
	["DRUID"]		= { r = 1.00; g = 0.50; b = 0.00; a = 1 },
	["PSIONIC"]		= { r = 1.00; g = 0.50; b = 1.00; a = 1 },
	["STALKER"]		= { r = 0.00; g = 0.78; b = 0.00; a = 1 },
	["PRIEST"]		= { r = 1.00; g = 1.00; b = 0.31; a = 1 },
	["NECROMANCER"]	= { r = 0.95; g = 0.17; b = 0.28; a = 1 },
	["BARD"]		= { r = 0.00; g = 0.45; b = 0.10; a = 1 }
})



function TrackEnvironment(event)

	if bExecLock or not bUIToggleVisible then
		return
	end
	
	bExecLock = true
	
	local detectedUnits = avatar.GetUnitList()
	local i = 1
	
	unitList  = {}
	
	for key, unitId in detectedUnits do
		
		-- Check if unit is player and not dead
		if unit.IsPlayer(unitId) and not object.IsDead(unitId) then
			
			local faction = unit.GetFaction(unitId)
			
			-- Check if player belongs to opposite faction
			if not faction.isFriend or (not raid.IsPlayerInAvatarsRaid(object.GetName(unitId)) and unit.GetZonePvPType(avatar.GetId())==0) then
			
				local fow           = unit.GetPvPFlagInfo(unitId)
				local unitClass     = unit.GetClass(unitId)
				local unitFlagged   = 0
				local unitHPP       = unit.GetHealthPercentage(unitId)
				local unitKiller = 0
				local unitRWNDS = unit.GetRelativeWoundsComplexity(unitId)
				local unitCURSE = unit.GetRuneWoundsComplexity(unitId)
				local unitDONAT = 0
				
				if unitCURSE > 0 then
				unitDONAT = unitCURSE * 10
				end
				
				if unitHPP < 100 then
				unitKiller = (100 - unitHPP) * 200
				end
				
				if fow.isOn then
					unitFlagged = PLAYERLIST_PRIORITY_FLAGGED * 125
				end
				
				unitList[i]             = {}
				unitList[i].id          = unitId
				unitList[i].priority    = (PLAYERLIST_PRIORITY_CLASSES[unitClass.className]) + unitFlagged + unitKiller + unitRWNDS + unitDONAT
				unitList[i].flagged     = fow.isOn
				
				i = i + 1
				
			end
			
		end
	end
	
	unitCount = i - 1
	
	detectedUnits = nil
	
	ClearPlayerList()
	
	if unitCount > 0 then
		CreatePlayerList()
		wtMainPanel:Show(true)
	else
		wtMainPanel:Show(false)
	end
	
	bExecLock = false
	
end

function CreatePlayerList()

	table.sort(unitList, function(a, b) return a.priority > b.priority end)
	
	for i = 1, unitCount do
	
		local unitId = unitList[i].id
		
		wtPlayerList_Names[i] = mainForm:CreateWidgetByDesc(wtPlayerList_Name:GetWidgetDesc())
		wtPlayerList_Names[i]:SetName("PlayerList_Name"..i)
		wtPlayerList_Names[i]:SetVal("Name", object.GetName(unitId))
		
		if unitList[i].flagged then
			wtPlayerList_Names[i]:SetClassVal("class", "tip_red")
		else
			wtPlayerList_Names[i]:SetClassVal("class", "tip_white")
		end
		
	
		local place = wtPlayerList_Names[i]:GetPlacementPlain()
		place.posY = PLAYERLIST_ROW_HEIGHT * i;
		wtPlayerList_Names[i]:SetPlacementPlain(place)
		
		wtPlayerList_Levels[i] = mainForm:CreateWidgetByDesc(wtPlayerList_Level:GetWidgetDesc())
        wtPlayerList_Levels[i]:SetName("PlayerList_Level"..i)
        wtPlayerList_Levels[i]:SetVal("Level", common.FormatInt(unit.GetLevel(unitId), "%d"))
        wtPlayerList_Levels[i]:SetClassVal("class", "tip_white")
        
        local place = wtPlayerList_Levels[i]:GetPlacementPlain()
        place.posY = PLAYERLIST_ROW_HEIGHT * i;
        wtPlayerList_Levels[i]:SetPlacementPlain(place)
		
		wtPlayerList_Healths[i] = mainForm:CreateWidgetByDesc(wtPlayerList_Health:GetWidgetDesc())
		wtPlayerList_Healths[i]:SetName("PlayerList_Health"..i)
		
		--local unitHP = unit.GetHealthPercentage(unitId)
		--local unitHP = unit.GetRuneWoundsComplexity(unitId)
		local unitWND = unit.GetRelativeWoundsComplexity(unitId)
	
		
		--wtPlayerList_Healths[i]:SetVal("Health", common.FormatInt(unitHP, "%d"))
		--Would be good to add total value of enemy runes, currently I don't think it is possible.
		wtPlayerList_Healths[i]:SetVal("Health", common.FormatInt(unitWND, "%d" ))
		wtPlayerList_Healths[i]:SetClassVal("class", "tip_white")
		
		--Maybe will add it later, now to much coloring.
		--if unitHP > 40 then
			--wtPlayerList_Healths[i]:SetClassVal("class", "tip_red")
		--elseif unitHP <= 40 and unitHP > 20 then
			--wtPlayerList_Healths[i]:SetClassVal("class", "tip_yellow")
		--elseif unitHP <= 20 then
			--wtPlayerList_Healths[i]:SetClassVal("class", "tip_green")
		--end
		
		local place = wtPlayerList_Healths[i]:GetPlacementPlain()
		place.posY = PLAYERLIST_ROW_HEIGHT * i;
		wtPlayerList_Healths[i]:SetPlacementPlain(place)
		
		wtButtonSelectors[i] = mainForm:CreateWidgetByDesc(wtButtonSelector:GetWidgetDesc())
		wtButtonSelectors[i]:SetName("ButtonSelector_"..i)
		
		local place = wtButtonSelectors[i]:GetPlacementPlain()
		place.posY = PLAYERLIST_ROW_HEIGHT * i;
		wtButtonSelectors[i]:SetPlacementPlain(place)
		
		local place
		local Percentage
		local PlayerClass
		
	
	wtTotHealths[i] = mainForm:CreateWidgetByDesc(wtTotHealth:GetWidgetDesc())
	Percentage = unit.GetHealthPercentage(unitId)
	PlayerClass = unit.GetClass(unitId)

	if Percentage ~= nil then
		place = wtTotHealths[i]:GetPlacementPlain()
		place.posY = PLAYERLIST_ROW_HEIGHT * i;
		place.sizeX = math.ceil( 175 * Percentage / 100 ) -- Health bar width, px = 86
		wtTotHealths[i]:SetBackgroundColor( ClassColors[PlayerClass.className] )
		wtTotHealths[i]:SetPlacementPlain(place)
	end
		
		
		wtMainPanel:AddChild(wtPlayerList_Names[i])
		wtMainPanel:AddChild(wtPlayerList_Levels[i])
		wtMainPanel:AddChild(wtPlayerList_Healths[i])
		wtMainPanel:AddChild(wtButtonSelectors[i])
		wtMainPanel:AddChild(wtTotHealths[i])
		
		if i >= PLAYERLIST_MAX_ROWS then
			break
		end
		
	end
	
	

end

function ClearPlayerList()
	
	if wtPlayerList_Names then
		for i, w in wtPlayerList_Names do
			wtPlayerList_Names[i]:DestroyWidget()
			wtPlayerList_Levels[i]:DestroyWidget()
			wtPlayerList_Healths[i]:DestroyWidget()
			wtTotHealths[i]:DestroyWidget()
			wtButtonSelectors[i]:DestroyWidget()
		end
	end
	
end

function ReactionSelectTarget(params)

	local senderIndex = tonumber(string.sub(params.sender, string.len("ButtonSelector_") + 1))
	
	if senderIndex then
		avatar.SelectTarget(unitList[senderIndex].id)
	end

end

function MemRequestHandler(params)
	userMods.SendEvent("U_EVENT_ADDON_MEM_USAGE_RESPONSE", {sender = common.GetAddonName(), memUsage = gcinfo()})
end

function ToggleDNDHandler(params)
	if params.target == common.GetAddonName() then
		DnD:Enable(wtMainPanel, params.state)
	end
end

function ToggleUIHandler(params)
	bUIToggleVisible = params.visible
	mainForm:Show( params.visible )
end


function Init()
	common.RegisterReactionHandler(ReactionSelectTarget, "SelectTarget")
	common.RegisterEventHandler(TrackEnvironment, "EVENT_SECOND_TIMER")
	common.RegisterEventHandler(MemRequestHandler, "U_EVENT_ADDON_MEM_USAGE_REQUEST")
	common.RegisterEventHandler(ToggleDNDHandler, "U_EVENT_TOGGLE_DND")
	common.RegisterEventHandler(ToggleUIHandler, "SCRIPT_TOGGLE_UI")
	
	wtMainPanel         = mainForm:GetChildChecked("MainPanel", false)
	wtPlayerList_Name   = wtMainPanel:GetChildChecked("PlayerList_Name", false)
	wtPlayerList_Level  = wtMainPanel:GetChildChecked("PlayerList_Level", false)
	wtPlayerList_Health = wtMainPanel:GetChildChecked("PlayerList_Health", false)
	wtButtonSelector    = wtMainPanel:GetChildChecked("ButtonSelector", false)
	wtTotHealth = wtMainPanel:GetChildChecked( "TotHealth", false )
	
	DnD:Init(wtMainPanelDNDId, wtMainPanel, wtMainPanel, true, true, {-8,-8,-8,-8})
	
	wtPlayerList_Name:Show(false)
	wtPlayerList_Level:Show(false)
	wtPlayerList_Health:Show(false)
	wtButtonSelector:Show(false)
	wtTotHealth:Show(false)
	
	wtMainPanel:Show(false)
	
	local place = wtMainPanel:GetPlacementPlain()
	place.sizeY = PLAYERLIST_ROW_HEIGHT * PLAYERLIST_MAX_ROWS + 36;
	wtMainPanel:SetPlacementPlain(place)
	

	
end

Init()