-- AoMapResources by SLA
-- Created: 2011-01-07
-- Updated: (see Revision)
-- http://ui9.ru/
--------------------------------------------------------------------------------
-- DATABASE
--------------------------------------------------------------------------------
Global( "AoMapResources", {
	Format = 1.00,
	Revision = 20110629
} )
--------------------------------------------------------------------------------
AoMapResources.InstanceMaps = {
	[ "DeathRealm" ] = { --  / Purgatory
		[ "Default" ] = {
			Texture = { name = "DeathRealm", ratio = 1 },
			Geodata = { x = 177.931, y = 210.460, width = 426.118, height = 327.158 },
		},
	},
	[ "InstLeague1" ] = { --    / Clement's Tower
		[ "Default" ] = {
			Geodata = { x = 221.428, y = 5730.570, width = 210.198, height = 161.383 },
		},
	},
	[ "Inst_Liga1End" ] = { --   / Oreshek Fortress
		[ "Default" ] = {
			Geodata = { x = 280.174, y = 5418.999, width = 559.826, height = 429.814 },
		},
	},
	-- NEED:   / Darkblood Citadel
	-- NEED:   / Castle Blight
	
	[ "InstEmpire1" ] = { --   "" / The Imperial Ship "Invincible"
		[ "Default" ] = {
			Geodata = { x = 1241.276, y = 1170.036, width = 317.689, height = 243.910 },
		},
		[ "FinalZone" ] = {
			Geodata = { x = 2589.892, y = 1357.077, width = 168.784, height = 129.586 },
		},
	},
	[ "Inst_Empire1End" ] = { --  / XAES
		[ "Default" ] = {
			Geodata = { x = 155.718, y = 5556.056, width = 622.445, height = 477.891 },
		},
	},
	-- NEED:   / Laguna Boil
	-- NEED:   / Lab Thirteen
	
	[ "Inst_miniTenzisTemple_League" ] = { --    () / Corridors of Tensess Temple (League)
		[ "Default" ] = {
			Geodata = { x = 371.322, y = 5478.045, width = 296.210, height = 227.420 },
		},
	},
	-- NEED:    () / Corridors of Tensess Temple (Empire)
	-- NEED:   / Heart of Tensess Temple
	-- NEED:   / Gorluxor's Tower
	-- NEED:   / Defiled Ruins
	-- NEED:   / Dead City
	-- NEED:   / Genoer the Devourer
	
	[ "NIhazIsland" ] = { --  / (Crossroads ?)
		[ "Default" ] = {
			Geodata = { x = 12092.689, y = 16486.380, width = 219.340, height = 168.401 },
		},
	},
}
--------------------------------------------------------------------------------
AoMapResources.KnownObjects = {
	-- Instances:
	[ "DeathRealm" ] = { --  / Purgatory
		{ Type = "Boss", Pos = { posX = 390.990, posY = 426.215 } },
	},
	-- League zones:
	[ "ZoneLeague1_Capital" ] = { --  / Novograd
	},
	[ "ZoneLeague1" ] = { --  / Lightwood
		{ Type = "Treasure", Pos = { posX = 14359.390, posY = 7223.810 } }, -- 75.92:36.50
		{ Type = "Treasure", Pos = { posX = 14262.800, posY = 6218.200 } }, -- 72.78:71.96
		{ Type = "Crystal01", SimplePos = { 47.50, 62.03 } }, 
		{ Type = "Crystal01", SimplePos = { 50.39, 60.20 } }, 
		{ Type = "Crystal01", SimplePos = { 51.04, 63.42 } }, 
		{ Type = "Crystal01", SimplePos = { 52.63, 58.96 } }, 
		{ Type = "Crystal01", Pos = { posX = 12693.740, posY = 6385.279 } }, -- 21.77:66.07
		{ Type = "Crystal01", Pos = { posX = 12787.105, posY = 6451.024 } }, -- 24.81:63.75 
		{ Type = "Crystal01", Pos = { posX = 12846.513, posY = 6423.205 } }, -- 26.74:64.73
		{ Type = "Crystal01", Pos = { posX = 12982.095, posY = 6708.991 } }, -- 31.15:54.65 
		{ Type = "Crystal01", Pos = { posX = 12982.685, posY = 6639.330 } }, -- 31.17:57.11
		{ Type = "Crystal01", Pos = { posX = 13016.179, posY = 6757.337 } }, -- 32.26:52.95
		{ Type = "Crystal01", Pos = { posX = 13961.650, posY = 5772.554 } }, -- 62.99:87.67 
		{ Type = "Crystal01", Pos = { posX = 13646.282, posY = 5674.920 } }, -- 52.74:91.12
		{ Type = "Crystal01", Pos = { posX = 13796.719, posY = 5848.962 } }, -- 57.63:84.98 
		{ Type = "Crystal01", Pos = { posX = 13835.197, posY = 5670.340 } }, -- 58.88:91.28
--		{ Type = "Crystal01", SimplePos = { 52.87, 32.68 } }, 
		{ Type = "Crystal01", SimplePos = { 54.54, 31.36 } }, 
		{ Type = "Crystal01", SimplePos = { 55.87, 30.13 } }, 
		{ Type = "Crystal01", SimplePos = { 52.34, 30.51 } }, 
		{ Type = "Crystal01", SimplePos = { 70.98, 19.67 } }, 
		{ Type = "Crystal01", SimplePos = { 71.76, 16.84 } }, 
		{ Type = "Crystal01", SimplePos = { 72.31, 17.77 } }, 
		{ Type = "Crystal01", SimplePos = { 72.34, 20.69 } }, 
		{ Type = "Crystal01", Pos = { posX = 14376.453, posY = 5981.602 } }, -- 76.48:80.30
		{ Type = "Crystal01", Pos = { posX = 14361.285, posY = 5895.875 } }, -- 75.98:83.33
		{ Type = "Crystal01", SimplePos = { 76.75, 46.45 } }, 
		{ Type = "Crystal01", SimplePos = { 76.31, 44.32 } }, 
		{ Type = "Crystal01", SimplePos = { 74.62, 45.09 } }, 
		{ Type = "Crystal01", SimplePos = { 75.07, 46.68 } }, 
		{ Type = "Crystal01", Pos = { posX = 14279.382, posY = 6900.417 } }, -- 73.32:47.90
		{ Type = "Crystal01", Pos = { posX = 12941.084, posY = 6717.963 } }, -- 29.81:54.34
		{ Type = "Crystal01", Pos = { posX = 13496.559, posY = 8014.686 } }, -- 47.87:8.61
		{ Type = "Crystal01", Pos = { posX = 13621.162, posY = 7988.401 } }, -- 51.92:9.54
		{ Type = "Crystal01", Pos = { posX = 14241.012, posY = 5948.304 } }, -- 72.07:81.48
		{ Type = "Crystal01", Pos = { posX = 14267.947, posY = 6046.933 } }, -- 72.95:78.00
		{ Type = "Crystal01", Pos = { posX = 13503.208, posY = 7904.858 } }, -- 48.09:12.49
		{ Type = "Crystal01", Pos = { posX = 13422.890, posY = 7892.129 } }, -- 45.48:12.94
		{ Type = "Crystal01", Pos = { posX = 13752.430, posY = 5672.530 } }, -- 56.19:91.20
		{ Type = "Crystal01", Pos = { posX = 13517.466, posY = 7972.680 } }, -- 48.55:10.10
		{ Type = "Crystal01", Pos = { posX = 12791.529, posY = 6392.453 } }, -- 24.95:65.82
		{ Type = "Crystal01", Pos = { posX = 13672.235, posY = 7334.628 } }, -- 53.58:32.59
		{ Type = "Crystal01", Pos = { posX = 12943.374, posY = 6764.836 } }, -- 29.89:52.6
	},
	[ "ZoneLeague2" ] = { --  / Siveria
		{ Type = "Treasure", Pos = { posX = 13924.449, posY = 9180.760 } }, -- 41.81:45.06
		{ Type = "Milestone", SimplePos = { 53.15, 73.50 } },
		{ Type = "Milestone", SimplePos = { 52.49, 79.51 } },
		{ Type = "Milestone", SimplePos = { 61.21, 77.67 } },
		{ Type = "Milestone", SimplePos = { 59.94, 83.47 } },
		{ Type = "Milestone", SimplePos = { 37.26, 62.94 } },
		{ Type = "Milestone", SimplePos = { 31.85, 57.04 } },
		{ Type = "Crystal01", Pos = { posX = 13520.940, posY = 9868.571 } }, -- 30.51:21.10
		{ Type = "Crystal01", Pos = { posX = 13532.524, posY = 9053.083 } }, -- 30.84:49.51
		{ Type = "Crystal01", Pos = { posX = 14070.955, posY = 9193.491 } }, -- 45.91:44.62
		{ Type = "Crystal01", Pos = { posX = 14112.156, posY = 8798.597 } }, -- 47.06:58.38
		{ Type = "Crystal01", Pos = { posX = 14447.900, posY = 8070.579 } }, -- 56.46:83.74
		{ Type = "Crystal01", Pos = { posX = 14481.858, posY = 9359.176 } }, -- 57.41:38.84 
		{ Type = "Crystal01", Pos = { posX = 14583.796, posY = 9592.183 } }, -- 60.27:30.73 
		{ Type = "Crystal01", Pos = { posX = 14607.546, posY = 8192.260 } }, -- 60.93:79.50 
		{ Type = "Crystal01", Pos = { posX = 14628.624, posY = 9704.775 } }, -- 61.52:26.80
		{ Type = "Crystal01", Pos = { posX = 14796.373, posY = 8516.494 } }, -- 66.22:68.21
		{ Type = "Crystal01", Pos = { posX = 14983.000, posY = 8555.923 } }, -- 71.44:66.83
		{ Type = "Crystal01", Pos = { posX = 13560.085, posY = 9867.935 } }, -- 31.61:21.12 
		{ Type = "Crystal01", Pos = { posX = 13854.422, posY = 9152.520 } }, -- 39.85:46.04 
		{ Type = "Crystal01", Pos = { posX = 14664.957, posY = 8569.241 } }, -- 62.54:66.37 
		{ Type = "Crystal01", Pos = { posX = 13725.791, posY = 8291.650 } }, -- 36.25:76.04 
		{ Type = "Crystal01", Pos = { posX = 14577.370, posY = 9462.149 } }, -- 60.09:35.26
		{ Type = "Crystal01", Pos = { posX = 14238.586, posY = 9446.369 } }, -- 50.60:35.81 
		{ Type = "Crystal01", Pos = { posX = 13803.304, posY = 9302.493 } }, -- 38.42:40.82 
		{ Type = "Crystal01", Pos = { posX = 14214.597, posY = 8882.304 } }, -- 49.93:55.46 
		{ Type = "Crystal01", Pos = { posX = 13621.641, posY = 8877.112 } }, -- 33.33:55.64 
		{ Type = "Crystal01", Pos = { posX = 13471.225, posY = 8838.794 } }, -- 29.12:56.98 
		{ Type = "Crystal01", Pos = { posX = 13420.186, posY = 8969.784 } }, -- 27.69:52.41
	},
	[ "ZoneLeague3" ] = { --  / Darkwater
		{ Type = "Treasure", Pos = { posX = 15598.250, posY = 5691.160 } }, -- 55.64:79.59
		{ Type = "Milestone", SimplePos = { 39.15, 69.20 } },
		{ Type = "Milestone", SimplePos = { 32.18, 64.59 } },
		{ Type = "Milestone", SimplePos = { 28.48, 26.18 } },
		{ Type = "Milestone", SimplePos = { 39.85, 21.76 } },
		{ Type = "Milestone", SimplePos = { 55.96, 12.07 } },
		{ Type = "Milestone", SimplePos = { 63.96, 15.94 } },
		{ Type = "Milestone", SimplePos = { 65.79, 58.52 } },
		{ Type = "Milestone", SimplePos = { 75.17, 56.62 } },
		{ Type = "Milestone", Pos = { posX = 15018.966, posY = 6025.649 } }, -- 39.16:69.19
		{ Type = "Crystal01", Pos = { posX = 15382.045, posY = 5793.041 } }, -- 49.49:76.42
		{ Type = "Crystal01", Pos = { posX = 16023.035, posY = 6891.451 } }, -- 67.73:42.26
		{ Type = "Crystal01", Pos = { posX = 15973.980, posY = 7062.479 } }, -- 66.33:36.94
		{ Type = "Crystal01", Pos = { posX = 15961.881, posY = 7004.271 } }, -- 65.99:38.75
		{ Type = "Crystal01", Pos = { posX = 15255.671, posY = 5879.659 } }, -- 45.89:73.73
		{ Type = "Crystal01", Pos = { posX = 15889.005, posY = 6971.250 } }, -- 63.92:39.77
		{ Type = "Crystal01", Pos = { posX = 16148.674, posY = 6977.902 } },
		{ Type = "Crystal01", Pos = { posX = 15401.017, posY = 5954.940 } }, -- 50.03:71.39
		{ Type = "Crystal02", Pos = { posX = 14789.014, posY = 6022.504 } }, -- 32.61:69.28
		{ Type = "Crystal02", Pos = { posX = 16127.804, posY = 6348.764 } }, -- 70.71:59.14
		{ Type = "Crystal02", Pos = { posX = 15652.828, posY = 7779.191 } }, -- 57.19:14.64
		{ Type = "Crystal02", Pos = { posX = 14639.678, posY = 7659.625 } }, -- 28.36:18.36
		{ Type = "Crystal02", Pos = { posX = 14935.063, posY = 6885.336 } }, -- 36.77:42.45
		{ Type = "Crystal02", Pos = { posX = 14879.937, posY = 6832.444 } }, -- 35.20:44.09
		{ Type = "Crystal02", Pos = { posX = 14913.209, posY = 6086.896 } }, -- 36.15:67.28
		{ Type = "Crystal02", Pos = { posX = 16301.114, posY = 6433.360 } }, -- 75.64:56.51
		{ Type = "Crystal02", Pos = { posX = 15635.200, posY = 7884.881 } }, -- 56.69:11.36
		{ Type = "Crystal02", Pos = { posX = 14585.246, posY = 7590.638 } }, -- 26.81:20.51
		{ Type = "Crystal02", Pos = { posX = 16229.989, posY = 6333.490 } }, -- 73.62:59.61
		{ Type = "Crystal02", Pos = { posX = 15633.218, posY = 7622.514 } }, -- 56.64:19.52
		{ Type = "Crystal02", Pos = { posX = 14572.210, posY = 7505.315 } }, -- 26.44:23.16
		{ Type = "Crystal02", Pos = { posX = 14790.971, posY = 6980.428 } }, -- 32.67:39.49
		{ Type = "Crystal02", Pos = { posX = 14928.206, posY = 6972.990 } }, -- 36.57:39.72
		{ Type = "Crystal02", Pos = { posX = 14828.908, posY = 6905.366 } }, -- 33.75:41.82
		{ Type = "Crystal02", Pos = { posX = 15743.693, posY = 7806.164 } }, -- 59.78:13.81
		{ Type = "Crystal02", Pos = { posX = 14834.809, posY = 7609.093 } }, -- 33.92:19.93
		{ Type = "Crystal02", Pos = { posX = 14776.800, posY = 7659.963 } }, -- 32.27:18.35
		{ Type = "Crystal02", Pos = { posX = 14721.736, posY = 5917.914 } }, -- 30.70:72.54
		{ Type = "Crystal02", Pos = { posX = 14895.574, posY = 5937.011 } }, -- 35.65:71.94
		{ Type = "Crystal02", Pos = { posX = 14789.023, posY = 6097.572 } }, -- 32.61:66.95
		{ Type = "Crystal02", Pos = { posX = 16321.684, posY = 6293.456 } }, -- 76.23:60.86
		{ Type = "Crystal02", Pos = { posX = 16108.513, posY = 6224.708 } }, -- 70.16:63.00
		{ Type = "Crystal02", Pos = { posX = 15520.305, posY = 7770.496 } }, -- 53.42:14.91
	},
	[ "ArchipelagoLeague1" ] = { --   / Evermeet Isle
	},
	[ "ArchipelagoLeague2" ] = { --   / Frozen Frontier
		{ Type = "Treasure", Pos = { posX = 12685.330, posY = 11856.120 } }, -- 67.17:33.49
		{ Type = "Milestone", SimplePos = { 32.83, 66.36 } },
		{ Type = "Milestone", SimplePos = { 31.21, 77.68 } },
		{ Type = "Milestone", SimplePos = { 56.69, 47.25 } },
		{ Type = "Milestone", SimplePos = { 42.20, 56.75 } },
		{ Type = "Milestone", SimplePos = { 81.57, 15.12 } },
		{ Type = "Milestone", SimplePos = { 72.60, 25.67 } },
		{ Type = "Milestone", Pos = { posX = 12903.444, posY = 12053.742 } }, -- 78.47:20.96
		{ Type = "Crystal01", Pos = { posX = 12681.057, posY = 10487.264 } }, -- 35.72:75.44
		{ Type = "Crystal01", Pos = { posX = 12723.591, posY = 11406.857 } }, -- 44.72:42.26
		{ Type = "Crystal01", Pos = { posX = 13125.548, posY = 11722.531 } }, -- 69.96:60.19
	},
	[ "ArchipelagoLeague3" ] = { --  / Tenebra
		{ Type = "Treasure", Pos = { posX = 15877.510, posY = 4143.800 } }, -- 73.12:65.53
		{ Type = "Milestone", SimplePos = { 28.23, 59.04 } },
		{ Type = "Milestone", SimplePos = { 27.17, 34.37 } },
		{ Type = "Milestone", SimplePos = { 72.01, 64.21 } },
		{ Type = "Milestone", SimplePos = { 79.39, 56.00 } },
		{ Type = "Milestone", SimplePos = { 41.96, 37.47 } },
		{ Type = "Milestone", SimplePos = { 32.89, 09.19 } },
		{ Type = "Crystal02", Pos = { posX = 15237.485, posY = 4509.846 } }, -- 27.66:35.96
		{ Type = "Crystal02", Pos = { posX = 15745.507, posY = 4383.272 } }, -- 63.74:46.18
		{ Type = "Crystal02", Pos = { posX = 15305.316, posY = 4280.578 } }, -- 32.48:54.48
		{ Type = "Crystal02", Pos = { posX = 15790.795, posY = 4320.638 } }, -- 66.96:51.24
		{ Type = "Crystal02", Pos = { posX = 15476.632, posY = 4136.473 } }, -- 44.65:66.12
		{ Type = "Crystal02", Pos = { posX = 15282.635, posY = 4224.838 } }, -- 30.87:58.98
		{ Type = "Crystal02", Pos = { posX = 15339.372, posY = 4425.597 } }, -- 34.90:42.76
		{ Type = "Crystal02", Pos = { posX = 15868.900, posY = 4364.710 } }, -- 70.28:20.42
		{ Type = "Crystal02", Pos = { posX = 15268.900, posY = 4413.520 } }, -- 70.28:20.30
                { Type = "Crystal02", Pos = { posX = 15804.142, posY = 4375.549 } }, -- 67.91:46.81
	},
	-- Empire zones:
	[ "ZoneEmpire1" ] = { --  / Nezebgrad
		{ Type = "Treasure", Pos = { posX = 11118.580, posY = 12646.790 } }, -- 43.94:57.49
        { Type = "Crystal01", Pos = { posX = 11976.934, posY = 13230.354 } }, -- 81.26:24.18
        { Type = "Crystal01", Pos = { posX = 11937.108, posY = 13177.154 } }, -- 79.53:27.22
        { Type = "Crystal01", Pos = { posX = 11967.478, posY = 13202.011 } }, -- 80.85:25.80
        { Type = "Crystal01", Pos = { posX = 11965.645, posY = 13171.592 } }, -- 80.77:27.53
        { Type = "Crystal01", Pos = { posX = 11904.837, posY = 13171.411 } }, -- 78.12:27.55
        { Type = "Crystal01", Pos = { posX = 11973.287, posY = 13153.559 } }, -- 81.10:28.56
	},
	[ "ZoneEmpire2_South" ] = { --    / Igsh Military District
		{ Type = "Treasure", Pos = { posX = 11771.294, posY = 10872.418 } }, -- 64.24:86.17
		{ Type = "Milestone", SimplePos = { 30.71, 09.79 } },
		{ Type = "Milestone", SimplePos = { 21.00, 26.00 } },
		{ Type = "Milestone", SimplePos = { 71.20, 65.18 } },
		{ Type = "Milestone", SimplePos = { 84.00, 53.00 } },
		{ Type = "Milestone", SimplePos = { 68.73, 18.05 } },
		{ Type = "Milestone", SimplePos = { 77.00, 12.00 } },
		{ Type = "Milestone", SimplePos = { 79.00, 09.00 } },
        { Type = "Crystal01", Pos = { posX = 10870.049, posY = 12194.328 } }, -- 29.03:22.80
        { Type = "Crystal01", Pos = { posX = 10621.476, posY = 11511.219 } }, -- 19.01:57.67
        { Type = "Crystal01", Pos = { posX = 10761.887, posY = 11067.212 } }, -- 24.67:80.34
        { Type = "Crystal01", Pos = { posX = 11588.456, posY = 10922.735 } }, -- 58.00:87.71
        { Type = "Crystal01", Pos = { posX = 11677.982, posY = 11681.115 } }, -- 61.61:49.00
        { Type = "Crystal01", Pos = { posX = 12395.830, posY = 12053.683 } }, -- 90.56:29.98
        { Type = "Crystal01", Pos = { posX = 10561.277, posY = 11344.650 } }, -- 16.58:66.17
        { Type = "Crystal01", Pos = { posX = 10884.006, posY = 11094.180 } }, -- 29.60:78.96
        { Type = "Crystal01", Pos = { posX = 11617.395, posY = 11018.128 } }, -- 59.17:82.84
        { Type = "Crystal01", Pos = { posX = 12205.414, posY = 12257.750 } }, -- 82.88:19.56
        { Type = "Crystal01", Pos = { posX = 10805.894, posY = 12163.782 } }, -- 26.45:24.36
        { Type = "Crystal01", Pos = { posX = 11793.868, posY = 11649.438 } }, -- 66.29:50.62
        { Type = "Crystal01", Pos = { posX = 12310.548, posY = 12120.050 } }, -- 87.12:26.59
        { Type = "Crystal01", Pos = { posX = 11567.277, posY = 11709.216 } }, -- 57.15:47.56
        { Type = "Crystal01", Pos = { posX = 10609.412, posY = 12262.455 } }, -- 18.52:19.32 
        { Type = "Crystal01", Pos = { posX = 10480.623, posY = 11392.994 } }, -- 13.33:63.71 
        { Type = "Crystal01", Pos = { posX = 11004.129, posY = 11172.488 } }, -- 34.44:74.96 
        { Type = "Crystal01", Pos = { posX = 11883.650, posY = 11187.781 } }, -- 69.91:74.18 
        { Type = "Crystal01", Pos = { posX = 10762.953, posY = 11162.322 } }, -- 24.72:75.48
        { Type = "Crystal01", Pos = { posX = 12265.945, posY = 11950.661 } }, -- 85.32:35.24
        { Type = "Crystal01", Pos = { posX = 11865.240, posY = 10980.887 } }, -- 69.16:84.74
        { Type = "Crystal01", Pos = { posX = 10414.216, posY = 11341.069 } }, -- 10.65:66.36
        { Type = "Crystal01", Pos = { posX = 11017.159, posY = 11043.593 } }, -- 34.97:81.54
        { Type = "Crystal01", SimplePos = { 76.09, 34.72 } },
        { Type = "Crystal01", SimplePos = { 16.80, 25.58 } },
		{ Type = "Crystal01", SimplePos = { 19.95, 29.94 } },
		{ Type = "Crystal01", SimplePos = { 16.30, 69.87 } },
		{ Type = "Crystal01", SimplePos = { 23.35, 29.29 } },
		{ Type = "Crystal01", SimplePos = { 11.88, 57.23} },
	},
	[ "ZoneEmpire2_North" ] = { --   / Severny Steppe
		{ Type = "Milestone", SimplePos = { 77.52, 12.48 } },
		{ Type = "Milestone", SimplePos = { 84.36, 53.06 } },
        { Type = "Crystal01", Pos = { posX = 11213.028, posY = 13334.581 } }, -- 42.52:56.37
        { Type = "Crystal01", Pos = { posX = 11161.183, posY = 13299.247 } }, -- 40.90:57.79
        { Type = "Crystal01", Pos = { posX = 10859.814, posY = 13004.914 } }, -- 31.45:69.63
        { Type = "Crystal01", Pos = { posX = 10914.018, posY = 12928.499 } }, -- 33.15:72.71
        { Type = "Crystal01", Pos = { posX = 11262.375, posY = 13305.564 } }, -- 44.07:57.54
        { Type = "Crystal01", Pos = { posX = 10831.000, posY = 12947.992 } }, -- 30.54:71.92
        { Type = "Crystal01", Pos = { posX = 11167.883, posY = 13348.124 } }, -- 41.11:55.83
        { Type = "Crystal01", Pos = { posX = 12542.322, posY = 12898.258 } }, -- 84.21:73.92
        { Type = "Crystal01", Pos = { posX = 10854.270, posY = 12909.628 } }, -- 31.27:73.47
        { Type = "Crystal01", Pos = { posX = 12617.528, posY = 12777.552 } }, -- 86.56:78.78
        { Type = "Crystal01", Pos = { posX = 12488.729, posY = 12751.294 } }, -- 82.53:79.84
        { Type = "Crystal01", Pos = { posX = 11243.736, posY = 13398.694 } }, -- 43.48:53.79
        { Type = "Crystal01", Pos = { posX = 10918.321, posY = 12991.397 } }, -- 33.28:70.18
		{ Type = "Crystal01", SimplePos = { 77.54, 76.97 } },
	},
	[ "ZoneEmpire3" ] = { -- ̸  / Dead Sea
		{ Type = "Treasure", Pos = { posX = 13156.140, posY = 10729.580 } }, -- 60.06:82.96
		{ Type = "Milestone", SimplePos = { 69.03, 29.47 } },
		{ Type = "Milestone", SimplePos = { 70.66, 42.55 } },
		{ Type = "Milestone", SimplePos = { 65.25, 60.60 } },
		{ Type = "Milestone", SimplePos = { 64.43, 69.14 } },
		{ Type = "Milestone", SimplePos = { 59.91, 25.70 } },
		{ Type = "Milestone", SimplePos = { 50.60, 17.76 } },
		{ Type = "Milestone", SimplePos = { 42.01, 69.89 } },
		{ Type = "Milestone", SimplePos = { 44.10, 85.08 } },
        { Type = "Crystal01", Pos = { posX = 12890.695, posY = 13114.088 } }, -- 52.58:15.29
        { Type = "Crystal02", Pos = { posX = 13290.668, posY = 12149.497 } }, -- 63.85:42.66
        { Type = "Crystal01", Pos = { posX = 13038.729, posY = 10627.572 } }, -- 56.75:85.85
        { Type = "Crystal02", Pos = { posX = 12802.612, posY = 11511.568 } }, -- 50.10:60.77
        { Type = "Crystal01", Pos = { posX = 13403.128, posY = 12479.580 } }, -- 67.02:33.30
        { Type = "Crystal02", Pos = { posX = 13276.039, posY = 12278.551 } }, -- 63.44:39.00
        { Type = "Crystal02", Pos = { posX = 12963.351, posY = 12533.277 } }, -- 54.63:31.77
        { Type = "Crystal01", Pos = { posX = 13577.766, posY = 11836.987 } }, -- 71.94:51.53
        { Type = "Crystal02", Pos = { posX = 13138.474, posY = 12291.013 } }, -- 59.56:38.65
        { Type = "Crystal01", Pos = { posX = 13348.133, posY = 12551.436 } }, -- 65.47:31.26
        { Type = "Crystal02", Pos = { posX = 13284.619, posY = 12330.803 } }, -- 63.68:37.52
        { Type = "Crystal01", Pos = { posX = 12815.138, posY = 13071.949 } }, -- 50.45:16.49
        { Type = "Crystal01", Pos = { posX = 13473.899, posY = 12690.574 } }, -- 69.01:27.31
        { Type = "Crystal02", Pos = { posX = 13096.121, posY = 12609.024 } }, -- 58.37:29.62 
        { Type = "Crystal01", Pos = { posX = 12883.400, posY = 13008.236 } }, -- 52.38:18.30
        { Type = "Crystal02", Pos = { posX = 13102.746, posY = 11615.375 } }, -- 58.56:57.82
        { Type = "Crystal01", Pos = { posX = 13511.859, posY = 11585.992 } }, -- 70.08:58.66
        { Type = "Crystal01", Pos = { posX = 13391.742, posY = 12720.929 } }, -- 66.70:26.45
        { Type = "Crystal01", Pos = { posX = 12470.930, posY = 11049.428 } }, -- 40.76:73.88
        { Type = "Crystal02", Pos = { posX = 12784.222, posY = 11708.532 } }, -- 49.58:55.18
        { Type = "Crystal01", Pos = { posX = 13470.500, posY = 11729.953 } }, -- 68.92:54.57  
        { Type = "Crystal01", Pos = { posX = 13029.923, posY = 10791.923 } }, -- 56.50:81.19
        { Type = "Crystal01", Pos = { posX = 12229.113, posY = 11035.125 } }, -- 33.95:74.29
        { Type = "Crystal02", Pos = { posX = 13001.697, posY = 12693.245 } }, -- 55.71:27.23
        { Type = "Crystal01", Pos = { posX = 13370.861, posY = 11621.927 } }, -- 66.11:57.64
        { Type = "Crystal02", Pos = { posX = 12976.637, posY = 11503.615 } }, -- 55.00:60.99
        { Type = "Crystal01", Pos = { posX = 13182.716, posY = 10766.644 } }, -- 60.81:81.91
        { Type = "Crystal01", Pos = { posX = 12386.792, posY = 10959.812 } }, -- 38.39:76.42
        { Type = "Crystal02", Pos = { posX = 13174.787, posY = 12153.362 } }, -- 60.59:42.55
        { Type = "Crystal02", Pos = { posX = 12931.763, posY = 12663.848 } }, -- 53.74:28.07
        { Type = "Crystal01", Pos = { posX = 12820.076, posY = 13200.155 } }, -- 50.59:12.85 
        { Type = "Crystal01", Pos = { posX = 13498.225, posY = 12566.813 } }, -- 69.70:30.82
        { Type = "Crystal02", Pos = { posX = 12970.177, posY = 11833.467 } }, -- 54.82:51.63
        { Type = "Crystal01", Pos = { posX = 12338.905, posY = 11098.289 } }, -- 37.04:72.49
        { Type = "Crystal02", SimplePos = { 59.19, 32.91 } }, -- Also: 57.27, 33.04
		{ Type = "Crystal01", SimplePos = { 58.98, 78.31 } }, -- Also: 59.22, 78.55
		{ Type = "Crystal01", SimplePos = { 65.09, 50.30 } },
		{ Type = "Crystal01", SimplePos = { 38.29, 80.30 } },
		{ Type = "Crystal01", SimplePos = { 51.58, 84.28 } },
		{ Type = "Crystal02", SimplePos = { 57.18, 33.16 } },
	},
	[ "ArchipelagoEmpire1" ] = { --   / ZIT Headquarters
		{ Type = "Treasure", Pos = { posX = 8915.189, posY = 9694.540 } }, -- 48.00:30.93
		{ Type = "Milestone", SimplePos = { 68.27, 83.32 } },
		{ Type = "Milestone", SimplePos = { 49.67, 79.14 } },
		{ Type = "Milestone", SimplePos = { 73.32, 47.78 } },
		{ Type = "Milestone", SimplePos = { 82.77, 64.14 } },
		{ Type = "Milestone", SimplePos = { 35.46, 30.86 } },
		{ Type = "Milestone", SimplePos = { 64.13, 34.52 } },
        { Type = "Crystal01", Pos = { posX = 12820.772, posY = 13188.076 } }, -- 50.61:13.19
        { Type = "Crystal01", Pos = { posX = 9015.939, posY = 9055.053 } }, -- 56.30:81.73
        { Type = "Crystal01", SimplePos = { 66.12, 78.90 } },
	},
	[ "ArchipelagoEmpire2" ] = { --   / Wild Isles
		{ Type = "Treasure", Pos = { posX = 16307.880, posY = 10377.630 } }, -- 23.98:81.71
		{ Type = "Milestone", SimplePos = { 55.47, 53.01 } },
		{ Type = "Milestone", SimplePos = { 31.40, 52.59 } },
		{ Type = "Milestone", SimplePos = { 76.12, 44.43 } },
		{ Type = "Milestone", SimplePos = { 76.00, 87.00 } },
		{ Type = "Milestone", SimplePos = { 33.02, 85.85 } },
		{ Type = "Milestone", SimplePos = { 14.88, 81.43 } },
        { Type = "Milestone", Pos = { posX = 16580.570, posY = 10690.437 } }, -- 45.64:54.15
        { Type = "Crystal02", Pos = { posX = 16945.391, posY = 11043.263 } }, -- 74.61:23.06
        { Type = "Crystal02", Pos = { posX = 16407.773, posY = 10687.060 } }, -- 31.91:54.44 
        { Type = "Crystal02", Pos = { posX = 16967.578, posY = 10399.123 } }, -- 76.38:79.81
        { Type = "Crystal02", Pos = { posX = 16541.668, posY = 10651.646 } }, -- 42.55:57.56
        { Type = "Crystal02", Pos = { posX = 16884.156, posY = 11153.240 } }, -- 69.75:13.37
        { Type = "Crystal02", Pos = { posX = 16783.188, posY = 11188.108 } }, -- 61.73:10.30 
        { Type = "Crystal02", Pos = { posX = 12903.124, posY = 13152.011 } }, -- 52.93:14.22
        { Type = "Crystal02", Pos = { posX = 12821.721, posY = 13186.451 } }, -- 50.64:13.24
        { Type = "Crystal02", Pos = { posX = 16999.020, posY = 10541.641 } }, -- 78.87:67.26
        { Type = "Crystal02", Pos = { posX = 16450.006, posY = 10308.620 } }, -- 35.27:87.79
        { Type = "Crystal02", Pos = { posX = 16692.480, posY = 10568.416 } }, -- 54.53:64.90
        { Type = "Crystal02", Pos = { posX = 16963.963, posY = 10408.291 } }, -- 76.09:79.01 
        { Type = "Crystal02", Pos = { posX = 13058.751, posY = 12482.353 } }, -- 57.32:33.22
        { Type = "Crystal02", Pos = { posX = 13389.397, posY = 12712.544 } }, -- 66.63:26.69
        { Type = "Crystal02", Pos = { posX = 16227.924, posY = 11021.768 } }, -- 17.63:24.95
        { Type = "Crystal02", Pos = { posX = 17085.113, posY = 10584.734 } }, -- 85.71:63.46
        { Type = "Crystal02", Pos = { posX = 16774.828, posY = 10696.403 } }, -- 61.07:53.62
        { Type = "Crystal02", Pos = { posX = 16223.052, posY = 10441.595 } }, -- 17.24:76.07
        { Type = "Crystal02", Pos = { posX = 16795.441, posY = 10861.112 } }, -- 62.70:39.11
        { Type = "Crystal02", Pos = { posX = 17012.355, posY = 11043.120 } }, -- 79.93:23.07
        { Type = "Crystal02", Pos = { posX = 16659.332, posY = 10883.114 } }, -- 51.89:37.17
        { Type = "Crystal02", Pos = { posX = 16650.152, posY = 10893.412 } }, -- 51.16:36.26
        { Type = "Crystal02", SimplePos = { 21.32, 39.57 } },
        { Type = "Crystal02", SimplePos = { 79.97, 86.83 } },
	},
	[ "ArchipelagoEmpire4" ] = { --   / Dream Factory
        { Type = "Crystal02", Pos = { posX = 12756.399, posY = 13981.104 } }, -- 59.17:45.48
	},
	-- Contested zones:
	[ "ZoneContested1" ] = { -- - / Asee-Teph
		{ Type = "Treasure", Pos = { posX = 13890.359, posY = 12812.380 } }, -- 73.97:34.12
		{ Type = "Treasure", Pos = { posX = 13560.420, posY = 12381.819 } }, -- 63.66:49.54
		{ Type = "Milestone", SimplePos = { 55.98, 39.56 } },
		{ Type = "Milestone", SimplePos = { 58.11, 52.90 } },
		{ Type = "Milestone", SimplePos = { 64.26, 38.09 } },
		{ Type = "Milestone", SimplePos = { 68.66, 50.78 } },
		{ Type = "Milestone", SimplePos = { 32.98, 57.95 } },
		{ Type = "Milestone", SimplePos = { 30.98, 43.86 } },
		{ Type = "Milestone", SimplePos = { 23.82, 50.14 } },
		{ Type = "Milestone", SimplePos = { 28.28, 59.01 } },
		{ Type = "Milestone", SimplePos = { 24.14, 60.99 } },
		{ Type = "Milestone", SimplePos = { 71.22, 61.11 } },
		{ Type = "Milestone", SimplePos = { 74.71, 51.51 } },
		{ Type = "Milestone", SimplePos = { 62.07, 32.69 } },
		{ Type = "Milestone", SimplePos = { 59.86, 28.31 } },
        { Type = "Milestone", Pos = { posX = 12577.856, posY = 12147.757 } }, -- 32.94:57.92
        { Type = "Crystal01", Pos = { posX = 13852.522, posY = 11626.464 } }, -- 72.79:76.60
        { Type = "Crystal02", Pos = { posX = 13182.759, posY = 12010.086 } }, -- 51.85:62.86
        { Type = "Crystal01", Pos = { posX = 12330.779, posY = 11352.978 } }, -- 25.22:86.39 
        { Type = "Crystal02", Pos = { posX = 12711.810, posY = 12515.188 } }, -- 37.13:44.76 
        { Type = "Crystal02", Pos = { posX = 13416.853, posY = 12093.416 } }, -- 59.17:59.87
        { Type = "Crystal02", Pos = { posX = 12727.914, posY = 12330.894 } }, -- 37.63:51.36
        { Type = "Crystal01", Pos = { posX = 13917.008, posY = 11752.335 } }, -- 74.80:72.09
        { Type = "Crystal02", Pos = { posX = 12554.445, posY = 12477.554 } }, -- 32.21:46.11
        { Type = "Crystal01", Pos = { posX = 13934.637, posY = 11643.073 } }, -- 75.36:76.00 
        { Type = "Crystal02", Pos = { posX = 13343.047, posY = 12026.095 } }, -- 56.86:62.28
        { Type = "Crystal02", Pos = { posX = 13308.322, posY = 11905.608 } }, -- 55.78:66.60
        { Type = "Crystal02", Pos = { posX = 12647.166, posY = 12391.662 } }, -- 35.11:49.19
		{ Type = "Crystal01", Pos = { posX = 12326.950, posY = 11524.606 } }, -- 25.10:80.24
		{ Type = "Crystal01", Pos = { posX = 12705.182, posY = 12927.174 } }, -- 36.92:30.01
		{ Type = "Crystal01", Pos = { posX = 12763.105, posY = 13029.747 } }, -- 38.73:26.33
		{ Type = "Crystal01", Pos = { posX = 12782.738, posY = 12907.364 } }, -- 39.35:30.72
		{ Type = "Crystal02", Pos = { posX = 13393.224, posY = 13156.655 } }, -- 58.43:21.79
		{ Type = "Crystal02", Pos = { posX = 13490.486, posY = 12997.260 } }, -- 61.47:27.50
        { Type = "Crystal01", Pos = { posX = 13822.986, posY = 11721.627 } }, -- 71.87:73.19
        { Type = "Crystal02", Pos = { posX = 13329.639, posY = 12138.598 } }, -- 56.44:58.25 
        { Type = "Crystal02", Pos = { posX = 12581.949, posY = 12366.952 } }, -- 33.07:50.07
        { Type = "Crystal02", SimplePos = { 64.01, 22.46 } },
		{ Type = "Crystal02", SimplePos = { 61.88, 19.56 } },
		{ Type = "Crystal01", SimplePos = { 43.67, 24.79 } },
		{ Type = "Crystal01", SimplePos = { 46.40, 30.00 } },
		{ Type = "Crystal01", SimplePos = { 42.32, 27.46 } },
		{ Type = "Crystal02", SimplePos = { 61.51, 24.63 } },
		{ Type = "Crystal02", SimplePos = { 60.10, 22.38 } },
	},
	[ "ZoneContested2" ] = { --  / Eljune
		{ Type = "Treasure", Pos = { posX = 10932.390, posY = 11818.930 } }, -- 35.37:63.13
		{ Type = "Milestone", SimplePos = { 70.87, 21.69 } },
		{ Type = "Milestone", SimplePos = { 60.48, 14.65 } },
		{ Type = "Milestone", SimplePos = { 27.79, 36.64 } },
		{ Type = "Milestone", SimplePos = { 37.43, 41.63 } },
		{ Type = "Milestone", SimplePos = { 28.28, 59.12 } },
		{ Type = "Milestone", SimplePos = { 32.97, 72.37 } },
		{ Type = "Milestone", SimplePos = { 65.80, 79.22 } },
		{ Type = "Milestone", SimplePos = { 58.51, 77.63 } },
		{ Type = "Milestone", SimplePos = { 61.47, 57.80 } },
		{ Type = "Milestone", SimplePos = { 62.30, 66.83 } },
		{ Type = "Milestone", SimplePos = { 40.88, 63.82 } },
		{ Type = "Milestone", SimplePos = { 37.01, 60.84 } },
		{ Type = "Milestone", SimplePos = { 28.29, 59.10 } },
        { Type = "Crystal01", Pos = { posX = 12275.081, posY = 11339.334 } }, -- 71.58:77.93
        { Type = "Crystal02", Pos = { posX = 11827.365, posY = 11527.306 } }, -- 59.50:72.13
        { Type = "Crystal02", Pos = { posX = 12259.700, posY = 11418.101 } }, -- 71.16:75.50
        { Type = "Crystal01", Pos = { posX = 11794.875, posY = 12586.872 } }, -- 58.63:39.44
        { Type = "Crystal01", Pos = { posX = 11842.373, posY = 12535.266 } }, -- 59.91:41.03
        { Type = "Crystal02", Pos = { posX = 11699.090, posY = 11424.555 } }, -- 56.04:75.30
        { Type = "Crystal01", Pos = { posX = 11024.396, posY = 11526.681 } }, -- 37.85:72.15
        { Type = "Crystal02", Pos = { posX = 10328.480, posY = 12234.402 } }, -- 19.08:50.31
        { Type = "Crystal02", Pos = { posX = 11894.146, posY = 11288.273 } }, -- 61.30:79.50
		{ Type = "Crystal02", Pos = { posX = 11874.367, posY = 13455.862 } }, -- 60.77:12.62
		{ Type = "Crystal02", Pos = { posX = 12122.040, posY = 13514.168 } }, -- 67.45:10.82
		{ Type = "Crystal02", Pos = { posX = 10304.486, posY = 12140.400 } }, -- 18.43:53.21
		{ Type = "Crystal01", Pos = { posX = 11199.046, posY = 11388.681 } }, -- 42.56:76.41
		{ Type = "Crystal02", Pos = { posX = 11749.104, posY = 11542.560 } }, -- 57.39:71.66
		{ Type = "Crystal02", Pos = { posX = 11862.016, posY = 11604.285 } }, -- 60.44:69.75
		{ Type = "Crystal02", Pos = { posX = 12067.452, posY = 13234.433 } }, -- 65.98:19.46
		{ Type = "Crystal01", Pos = { posX = 12266.486, posY = 11425.636 } }, -- 71.35:75.27
        { Type = "Crystal01", Pos = { posX = 11066.021, posY = 11652.085 } }, -- 38.97:68.28
        { Type = "Crystal02", Pos = { posX = 10526.546, posY = 12084.928 } }, -- 24.42:54.92
        { Type = "Crystal01", Pos = { posX = 11999.993, posY = 12379.426 } }, -- 64.16:45.84
        { Type = "Crystal02", Pos = { posX = 11799.229, posY = 11416.980 } }, -- 58.74:75.53
        { Type = "Crystal01", Pos = { posX = 12194.606, posY = 11513.771 } }, -- 69.41:72.55
        { Type = "Crystal02", Pos = { posX = 10422.309, posY = 12077.140 } }, -- 21.61:55.16
        { Type = "Crystal01", SimplePos = { 62.24, 41.65 } },
		{ Type = "Crystal01", SimplePos = { 61.87, 44.98 } },
		{ Type = "Crystal01", SimplePos = { 60.29, 43.45 } },
        { Type = "Crystal02", SimplePos = { 19.40, 48.17 } },
        { Type = "Crystal02", SimplePos = { 71.24, 18.89 } },
		{ Type = "Crystal02", SimplePos = { 68.16, 19.51 } },
		{ Type = "Crystal02", SimplePos = { 64.68, 23.15 } },
		{ Type = "Crystal01", Pos = { posX = 11918.618, posY = 12508.341 } }, -- 61.96:41.86 -- ?
		{ Type = "Crystal02", Pos = { posX = 12256.340, posY = 13263.620 } }, -- 71.07:18.56 -- ?
		{ Type = "Crystal02", Pos = { posX = 11918.283, posY = 13409.151 } }, -- 61.95:14.07
		{ Type = "Crystal02", Pos = { posX = 10318.783, posY = 12128.284 } }, -- 18.82:53.59		
	},
	[ "ZoneContested3" ] = { --   / Coba Plateau
		{ Type = "Treasure", Pos = { posX = 16019.819, posY = 12677.880 } }, -- 85.75:50.40
		{ Type = "Milestone", SimplePos = { 73.32, 21.01 } },
		{ Type = "Milestone", SimplePos = { 77.10, 34.83 } },
		{ Type = "Milestone", SimplePos = { 67.22, 32.25 } },
		{ Type = "Milestone", SimplePos = { 60.90, 26.60 } },
		{ Type = "Milestone", SimplePos = { 34.04, 30.25 } },
		{ Type = "Milestone", SimplePos = { 16.15, 25.83 } },
		{ Type = "Milestone", SimplePos = { 41.65, 72.96 } },
		{ Type = "Milestone", SimplePos = { 29.62, 81.21 } },
		{ Type = "Milestone", SimplePos = { 66.18, 75.40 } },
		{ Type = "Milestone", SimplePos = { 60.98, 63.67 } },
		{ Type = "Milestone", SimplePos = { 30.37, 53.35 } },
		{ Type = "Milestone", SimplePos = { 41.70, 49.17 } },
		{ Type = "Crystal01", Pos = { posX = 14918.785, posY = 13097.787 } },
		{ Type = "Crystal01", SimplePos = { 53.61, 34.69 } },
		{ Type = "Crystal01", SimplePos = { 51.66, 37.59 } },
		{ Type = "Crystal01", SimplePos = { 51.22, 40.57 } },
		{ Type = "Crystal01", Pos = { posX = 14874.021, posY = 13056.748 } }, -- 48.56:36.12
		{ Type = "Crystal01", Pos = { posX = 15014.094, posY = 12998.220 } }, -- 53.10:38.33
		{ Type = "Crystal01", Pos = { posX = 14910.609, posY = 13003.468 } }, -- 49.74:38.13
		{ Type = "Crystal02", Pos = { posX = 15057.040, posY = 12163.105 } }, -- 54.50:69.80
		{ Type = "Crystal02", Pos = { posX = 15146.596, posY = 12210.367 } }, -- 57.40:68.02
		{ Type = "Crystal02", SimplePos = { 51.39, 70.73 } },
		{ Type = "Crystal02", Pos = { posX = 15026.580, posY = 12102.204 } }, -- 53.51:72.10
		{ Type = "Crystal02", Pos = { posX = 15066.318, posY = 12270.767 } }, -- 54.80:65.75
		{ Type = "Crystal03", Pos = { posX = 15704.711, posY = 13153.894 } }, -- 75.52:32.46
		{ Type = "Crystal03", Pos = { posX = 15749.673, posY = 13226.883 } }, -- 76.98:29.71
		{ Type = "Crystal03", SimplePos = { 79.36, 26.66 } },
		{ Type = "Crystal03", Pos = { posX = 15825.190, posY = 13362.770 } }, -- 79.43:24.58
		{ Type = "Crystal03", Pos = { posX = 15692.366, posY = 13346.575 } }, -- 75.12:25.20
		{ Type = "Crystal03", SimplePos = { 74.50, 28.55 } },
		{ Type = "Crystal03", Pos = { posX = 15730.776, posY = 13279.703 } }, -- 76.36:27.72
		{ Type = "Crystal03", Pos = { posX = 15473.034, posY = 12265.544 } }, -- 68.00:65.94
		{ Type = "Crystal03", Pos = { posX = 15599.713, posY = 12147.138 } }, -- 72.11:70.41
		{ Type = "Crystal03", Pos = { posX = 15633.375, posY = 12219.654 } }, -- 73.20:67.67
		{ Type = "Crystal03", Pos = { posX = 15646.485, posY = 12410.788 } }, -- 73.63:60.47
		{ Type = "Crystal03", Pos = { posX = 15706.252, posY = 12225.536 } }, -- 75.57:67.45
		{ Type = "Crystal03", Pos = { posX = 15714.125, posY = 12307.114 } }, -- 75.82:64.38
        { Type = "Crystal03", Pos = { posX = 14697.671, posY = 12674.031 } }, -- 42.83:50.55
		{ Type = "Crystal03", SimplePos = { 41.27, 49.76 } },
		{ Type = "Crystal03", SimplePos = { 38.25, 47.33 } },
		{ Type = "Crystal03", SimplePos = { 33.48, 49.87 } },
        { Type = "Crystal03", Pos = { posX = 14574.894, posY = 12538.509 } }, -- 38.85:55.65
		{ Type = "Crystal02", Pos = { posX = 14260.357, posY = 13507.885 } }, -- 28.64:19.11
		{ Type = "Crystal02", Pos = { posX = 14163.221, posY = 13418.808 } }, -- 25.49:22.47
		{ Type = "Crystal02", Pos = { posX = 14235.920, posY = 13380.256 } }, -- 27.85:23.93
		{ Type = "Crystal02", SimplePos = { 27.31, 27.87 } },
		{ Type = "Crystal02", Pos = { posX = 14260.523, posY = 13320.864 } }, -- 28.64:26.16
		{ Type = "Crystal02", Pos = { posX = 14302.579, posY = 13311.500 } }, -- 30.01:26.52
        { Type = "Crystal03", Pos = { posX = 14467.238, posY = 12532.619 } }, -- 35.35:55.88
        { Type = "Crystal03", Pos = { posX = 15580.364, posY = 12305.106 } }, -- 71.48:64.45
        { Type = "Crystal03", Pos = { posX = 15660.733, posY = 12167.592 } }, -- 74.09:69.63
        { Type = "Crystal03", Pos = { posX = 15654.693, posY = 12267.873 } }, -- 73.89:65.85
        { Type = "Crystal03", Pos = { posX = 14672.355, posY = 12587.871 } }, -- 42.01:53.79
        { Type = "Crystal03", Pos = { posX = 14597.658, posY = 12678.857 } }, -- 39.59:50.36
        { Type = "Crystal02", Pos = { posX = 14117.822, posY = 13310.470 } }, -- 24.01:26.56
        { Type = "Crystal03", Pos = { posX = 15506.279, posY = 12328.581 } }, -- 69.08:63.57
        { Type = "Crystal02", Pos = { posX = 15138.350, posY = 12169.051 } }, -- 57.14:69.58
        { Type = "Crystal02", SimplePos = { 53.56, 67.87 } },
        -- { Type = "Crystal02", SimplePos = { 54.91, 69.90 } }, -- ???
        { Type = "Crystal03", SimplePos = { 70.80, 68.36 } },
		{ Type = "Crystal03", SimplePos = { 72.21, 62.21 } },
		{ Type = "Crystal03", SimplePos = { 72.38, 66.52 } },
		{ Type = "Crystal03", SimplePos = { 71.31, 59.67 } },
		{ Type = "Crystal03", SimplePos = { 77.66, 33.28 } },
		{ Type = "Crystal03", SimplePos = { 69.05, 67.88 } },
		{ Type = "Crystal03", SimplePos = { 76.38, 34.88 } },
		{ Type = "Crystal02", Pos = { posX = 14281.959, posY = 13252.954 } }, -- 29.34:28.72
	},
	[ "ZoneContested4" ] = { --  / Kirah
		{ Type = "Treasure", Pos = { posX = 11300.180, posY = 11706.170 } }, -- 45.47:56.34
		{ Type = "Crystal02", SimplePos = { 22.48, 50.01 } }, 
		{ Type = "Crystal02", SimplePos = { 22.87, 52.51 } }, 
		{ Type = "Crystal02", SimplePos = { 24.47, 48.81 } }, 
		{ Type = "Crystal02", Pos = { posX = 10490.542, posY = 11808.078 } }, -- 24.51:53.21 
		{ Type = "Crystal02", SimplePos = { 26.43, 49.56 } }, 
		{ Type = "Crystal02", Pos = { posX = 10576.071, posY = 12007.458 } }, -- 26.72:47.11 
		{ Type = "Crystal03", Pos = { posX = 11284.723, posY = 11915.786 } }, -- 45.07:49.91 
		{ Type = "Crystal03", Pos = { posX = 11323.016, posY = 11861.024 } }, -- 46.06:51.59 
		{ Type = "Crystal03", Pos = { posX = 11385.190, posY = 11901.300 } }, -- 47.67:50.36 
		{ Type = "Crystal03", SimplePos = { 49.53, 51.42 } }, 
		{ Type = "Crystal03", Pos = { posX = 11476.689, posY = 11933.900 } }, -- 50.04:49.36
		{ Type = "Crystal03", Pos = { posX = 11387.803, posY = 11821.358 } }, -- 47.74:52.81
		{ Type = "Crystal03", Pos = { posX = 11724.263, posY = 12054.135 } }, -- 56.45:45.68 
		{ Type = "Crystal03", Pos = { posX = 11785.657, posY = 12145.805 } }, -- 58.04:42.87 
		{ Type = "Crystal03", Pos = { posX = 11794.597, posY = 12085.092 } }, -- 58.28:44.73 
		{ Type = "Crystal03", Pos = { posX = 11839.663, posY = 12197.622 } }, -- 59.44:41.28 
		{ Type = "Crystal03", Pos = { posX = 11844.363, posY = 12092.164 } }, -- 59.56:44.51 
		{ Type = "Crystal03", SimplePos = { 27.44, 74.37 } }, 
		{ Type = "Crystal03", SimplePos = { 29.45, 72.27 } }, 
		{ Type = "Crystal03", SimplePos = { 29.96, 75.81 } }, 
		{ Type = "Crystal03", SimplePos = { 30.35, 74.21 } }, 
		{ Type = "Crystal03", SimplePos = { 31.67, 76.00 } }, 
		{ Type = "Crystal03", SimplePos = { 33.27, 72.59 } }, 
		{ Type = "Crystal03", SimplePos = { 33.61, 74.05 } }, 
		{ Type = "Crystal01", SimplePos = { 51.33, 72.93 } }, 
		{ Type = "Crystal01", SimplePos = { 52.15, 77.20 } }, 
		{ Type = "Crystal01", SimplePos = { 55.15, 77.95 } }, 
		{ Type = "Crystal01", SimplePos = { 58.35, 75.35 } }, 
		{ Type = "Crystal01", SimplePos = { 57.28, 70.80 } }, 
		{ Type = "Crystal01", SimplePos = { 53.17, 70.80 } }, 
		{ Type = "Crystal01", Pos = { posX = 11597.429, posY = 11232.695 } }, -- :70.84 
		{ Type = "Crystal03", Pos = { posX = 12016.735, posY = 11664.037 } }, -- 64.03:57.63 
		{ Type = "Crystal03", SimplePos = { 64.53, 55.71 } }, 
		{ Type = "Crystal03", Pos = { posX = 12116.448, posY = 11621.949 } }, -- 66.61:58.92 
		{ Type = "Crystal03", Pos = { posX = 12160.207, posY = 11639.327 } }, -- 67.74:58.38 
		{ Type = "Crystal03", SimplePos = { 67.18, 55.74 } }, 
		{ Type = "Crystal02", SimplePos = { 77.57, 72.16 } }, 
		{ Type = "Crystal02", SimplePos = { 78.51, 74.44 } }, 
		{ Type = "Crystal02", SimplePos = { 79.61, 71.74 } }, 
		{ Type = "Crystal02", SimplePos = { 80.68, 70.45 } }, 
		{ Type = "Crystal02", SimplePos = { 81.36, 72.84 } }, 
		{ Type = "Crystal02", Pos = { posX = 10550.767, posY = 11840.285 } }, -- 26.07:52.23
		{ Type = "Mail1", SimplePos = { 55.94, 81.15 } }, 
		{ Type = "Mail1", SimplePos = { 56.48, 80.99 } }, 
		{ Type = "Mail1", SimplePos = { 61.90, 70.39 } }, 
		{ Type = "Mail1", SimplePos = { 62.65, 69.47 } }, 
		{ Type = "Mail1", SimplePos = { 68.10, 68.21 } }, 
		{ Type = "Mail1", SimplePos = { 68.45, 70.59 } }, 
		{ Type = "Mail1", SimplePos = { 68.68, 65.52 } }, 
		{ Type = "Mail1", SimplePos = { 69.18, 70.03 } }, 
		{ Type = "Mail1", SimplePos = { 69.20, 63.29 } }, 
		{ Type = "Mail1", SimplePos = { 69.33, 74.30 } }, 
		{ Type = "Mail1", SimplePos = { 70.85, 74.60 } }, 
		{ Type = "Mail2", SimplePos = { 49.04, 59.93 } }, 
		{ Type = "Mail2", SimplePos = { 62.62, 55.99 } }, 
		{ Type = "Mail2", SimplePos = { 63.70, 57.97 } }, 
		{ Type = "Mail2", SimplePos = { 63.81, 58.10 } }, 
		{ Type = "Mail2", SimplePos = { 64.30, 58.54 } }, 
		{ Type = "Mail2", SimplePos = { 64.81, 64.16 } }, 
		{ Type = "Mail2", SimplePos = { 65.60, 60.94 } }, 
		{ Type = "Mail2", SimplePos = { 65.89, 60.54 } }, 
		{ Type = "Mail2", SimplePos = { 66.00, 59.61 } }, 
		{ Type = "Mail2", SimplePos = { 66.05, 59.91 } }, 
		{ Type = "Mail2", SimplePos = { 66.10, 60.21 } }, 
		{ Type = "Mail2", SimplePos = { 67.83, 58.11 } }, 
		{ Type = "Mail2", SimplePos = { 70.18, 55.88 } }, 
	},
	[ "ZoneContested5" ] = { --   / Melting Isle
	},
	[ "ArchipelagoContested1" ] = { --  / Coldberg
		{ Type = "Treasure", Pos = { posX = 18484.650, posY = 13792.420 } }, -- 33.87:31.79
		{ Type = "Milestone", SimplePos = { 24.53, 38.86 } },
		{ Type = "Milestone", SimplePos = { 43.06, 52.92 } },
		{ Type = "Milestone", SimplePos = { 53.40, 18.72 } },
		{ Type = "Milestone", SimplePos = { 49.21, 34.30 } },
		{ Type = "Milestone", SimplePos = { 82.13, 58.44 } },
		{ Type = "Milestone", SimplePos = { 73.66, 45.92 } },
		{ Type = "Milestone", SimplePos = { 49.54, 80.69 } },
		{ Type = "Milestone", SimplePos = { 44.49, 62.02 } },
		{ Type = "Crystal03", Pos = { posX = 18603.085, posY = 14010.248 } }, -- 42.95:13.55 
		{ Type = "Crystal03", Pos = { posX = 18722.010, posY = 13225.739 } }, -- 52.07:79.25 
		{ Type = "Crystal03", Pos = { posX = 18741.230, posY = 13584.389 } }, -- 53.55:49.21 
		{ Type = "Crystal03", Pos = { posX = 18741.230, posY = 13584.389 } }, -- 53.55:49.21 
		{ Type = "Crystal03", Pos = { posX = 18864.852, posY = 13594.781 } }, -- 63.03:48.34 
	},
	[ "ArchipelagoContested2" ] = { --  / Avilon
		{ Type = "Treasure", Pos = { posX = 8631.870, posY = 11954.000 } }, -- 81.56:49.03
		{ Type = "Milestone", SimplePos = { 48.98, 73.19 } },
		{ Type = "Milestone", SimplePos = { 27.23, 78.37 } },
		{ Type = "Milestone", SimplePos = { 23.62, 54.29 } },
		{ Type = "Milestone", SimplePos = { 27.09, 43.14 } },
		{ Type = "Milestone", SimplePos = { 51.65, 29.19 } },
		{ Type = "Milestone", SimplePos = { 26.75, 33.80 } },
		{ Type = "Milestone", SimplePos = { 67.89, 52.18 } },
		{ Type = "Milestone", SimplePos = { 77.26, 61.46 } },
		{ Type = "Crystal03", Pos = { posX = 8217.948, posY = 11541.815 } }, -- 53.09:83.93 
		{ Type = "Crystal03", Pos = { posX = 7933.705, posY = 12024.342 } }, -- 33.54:43.07 
		{ Type = "Crystal03", Pos = { posX = 12949.300, posY = 8954.368 } }, -- 46.74:40.54 
		{ Type = "Crystal03", Pos = { posX = 13326.713, posY = 8251.734 } }, -- 71.97:87.73 
	},
	[ "ArchipelagoContested3" ] = { --   / Dragon Ring
		{ Type = "Treasure", Pos = { posX = 13442.330, posY = 8453.910 } }, -- 79.70:74.15
		{ Type = "Milestone", SimplePos = { 55.33, 17.25 } },
		{ Type = "Milestone", SimplePos = { 48.35, 35.97 } },
		{ Type = "Milestone", SimplePos = { 37.22, 35.31 } },
		{ Type = "Milestone", SimplePos = { 47.95, 66.89 } },
		{ Type = "Milestone", SimplePos = { 36.55, 67.39 } },
		{ Type = "Milestone", SimplePos = { 58.99, 74.27 } },
		{ Type = "Milestone", SimplePos = { 76.46, 64.86 } },
		{ Type = "Milestone", SimplePos = { 74.47, 64.95 } },
        { Type = "Milestone", Pos = { posX = 13166.500, posY = 9133.384 } }, -- 61.26:28.52
		{ Type = "Crystal03", Pos = { posX = 13149.343, posY = 9147.083 } }, -- 60.12:27.60 
		{ Type = "Crystal03", Pos = { posX = 12842.479, posY = 9072.845 } }, -- 39.60:32.58 
		{ Type = "Crystal03", Pos = { posX = 13370.275, posY = 8480.404 } }, -- 74.88:72.37 
		{ Type = "Crystal03", SimplePos = { 67.21, 22.96} },
		{ Type = "Crystal03", SimplePos = { 48.54, 30.39} }, -- my last crystal :)))
	},
	[ "ArchipelagoContested4" ] = { --   / Yazes Shard
		{ Type = "Treasure", Pos = { posX = 12624.229, posY = 13756.680 } }, -- 65.19:42.42
		{ Type = "Milestone", SimplePos = { 62.96, 44.62 } },
		{ Type = "Milestone", SimplePos = { 73.00, 35.00 } },
		{ Type = "Milestone", SimplePos = { 37.51, 43.05 } },
		{ Type = "Milestone", SimplePos = { 33.40, 36.76 } },
		{ Type = "Milestone", SimplePos = { 41.32, 65.23 } },
		{ Type = "Milestone", SimplePos = { 27.00, 63.00 } },
		{ Type = "Milestone", SimplePos = { 61.62, 65.48 } },
		{ Type = "Milestone", Pos = { posX = 12367.006, posY = 13204.241 } }, -- 55.10:65.34
        { Type = "Crystal03", Pos = { posX = 12853.191, posY = 13955.000 } }, -- 74.16:34.19
        { Type = "Crystal03", SimplePos = { 66.49, 53.55 } },
        { Type = "Crystal03", SimplePos = { 29.67, 36.41 } },
        { Type = "Crystal03", SimplePos = { 76.84, 51.51 } },
		{ Type = "Crystal03", SimplePos = { 73.36, 47.85 } },
		{ Type = "Crystal03", SimplePos = { 24.91, 43.27 } },
		{ Type = "Crystal03", SimplePos = { 25.65, 51.98 } },
		{ Type = "Crystal03", SimplePos = { 67.31, 45.96 } },
	},
	[ "ArchipelagoGipat1" ] = { --   / Gipat
		{ Type = "Treasure", Pos = { posX = 12761.763, posY = 16326.056 } }, -- 28.28:52.17
		{ Type = "Milestone", SimplePos = { 41.52, 58.79 } },
		{ Type = "Milestone", SimplePos = { 24.85, 55.01 } },
		{ Type = "Milestone", SimplePos = { 46.74, 32.33 } },
		{ Type = "Milestone", SimplePos = { 39.59, 34.06 } },
		{ Type = "Milestone", SimplePos = { 64.03, 57.40 } },
		{ Type = "Milestone", SimplePos = { 71.53, 60.27 } },
		{ Type = "Milestone", SimplePos = { 45.11, 85.27 } },
		{ Type = "Milestone", SimplePos = { 61.11, 78.85 } },
		{ Type = "Milestone", SimplePos = { 59.13, 29.22 } },
		{ Type = "Milestone", SimplePos = { 59.10, 29.29 } },
		{ Type = "Milestone", SimplePos = { 68.23, 34.48 } },
		{ Type = "Crystal03", SimplePos = { 25.30, 56.42 } }, 
		{ Type = "Crystal03", Pos = { posX = 12958.513, posY = 16478.881 } }, -- 35.89:45.25 
		{ Type = "Crystal03", Pos = { posX = 12760.854, posY = 16453.616 } }, -- 28.25:46.40 
		{ Type = "Crystal03", Pos = { posX = 12877.950, posY = 16531.045 } }, -- 32.78:42.89
		{ Type = "Crystal03", Pos = { posX = 13291.800, posY = 15676.560 } }, -- 48.79:81.56 
		{ Type = "Crystal03", Pos = { posX = 13294.106, posY = 15867.032 } }, -- 48.88:72.94 
		{ Type = "Crystal03", Pos = { posX = 13458.843, posY = 15692.588 } }, -- 55.26:80.83 
		{ Type = "Crystal03", Pos = { posX = 13447.925, posY = 15921.850 } }, -- 54.83:70.46 
		{ Type = "Crystal03", Pos = { posX = 13720.470, posY = 16758.820 } }, -- 65.38:32.59 
		{ Type = "Crystal03", Pos = { posX = 13796.956, posY = 16576.194 } }, -- 68.34:40.85 
		{ Type = "Crystal03", SimplePos = { 60.57, 36.36 } }, 
		{ Type = "Crystal03", Pos = { posX = 13573.098, posY = 16828.948 } }, -- 59.68:29.41 
		{ Type = "Crystal03", Pos = { posX = 13601.660, posY = 16590.394 } }, -- 60.78:40.21
        { Type = "Crystal03", Pos = { posX = 13563.212, posY = 15779.571 } }, -- 59.30:76.90
        { Type = "Crystal03", SimplePos = { 32.14, 47.98 } },
		{ Type = "Crystal03", SimplePos = { 37.88, 49.40 } },
      { Type = "Treasure", Text = "  .     -  ,   -       ,    : 12534245 -   '''',  21453135 -  ''''", Pos = { posX = 13132.428, posY = 16722.473 } }, -- 42.62:34.23
	},
	[ "ArchipelagoContested5" ] = { --   / Isle of Revelation (?)
		{ Type = "Treasure", Pos = { posX = 8001.600, posY = 8974.540 } }, -- 54.74:65.82
	},
	[ "ArchipelagoContested6" ] = { --   / Twilight Isle (?)
		{ Type = "Treasure", Pos = { posX = 11901.380, posY = 11434.729 } }, -- 85.68:54.85
	},
	-- Astral isles:
	[ "AstralIsland01" ] = { --  9 / Lab Nine
	},
	[ "AstralIsland02" ] = { --  / Zavert Isle
	},
	[ "AstralIsland03" ] = { --   / Bloodclaw Isle
	},
	[ "AstralIsland04" ] = { --   / Glitterlake Isle
	},
	[ "AstralIsland05" ] = { --   / New Life
	},
	[ "AstralIsland06" ] = { --   / Drywind Isle
	},
	[ "AstralIsland07" ] = { --   / Silent Isle
	},
	[ "AstralIsland08" ] = { --   / Lost Isle
	},
	[ "AstralIsland09" ] = { --   / Goblin Republic
	},
	[ "AstralIsland10" ] = { --   / SCrystal02glers' Isle
	},
	[ "AstralIsland11" ] = { --  / Abandoned Pyramid
	},
	[ "AstralIsland12" ] = { --   / Hikut Shard
	},
	[ "AstralIsland13" ] = { --   / (?)
	},
	[ "AstralIsland14" ] = { --  / (?)
	},
	-- Other:
	[ "PetRealm" ] = { --   / Kingdom of Nature
	},
	[ "ZoneContestedG" ] = { --   / Marauders' Isle
	},
	[ "GipatCave" ] = { --   / Defiled Ruins
	},
	[ "ZoneContested4Isle1" ] = { --   / (?)
	},
	[ "ZoneContested4Isle2" ] = { --   / June Grave
	},
	[ "Maze" ] = { --   / (?)
	},
	[ "GurluhsorTower" ] = { --   / Gorluxor's Tower
	},
	[ "HaloIsle" ] = { --   / The Forgotten Temple
	},
	[ "TWars_Isle_01" ] = { --   / Isle of Contention
	},
}
--------------------------------------------------------------------------------
AoMapResources.ObjectTypesList = { -- The list of valid icons.
	"Boss",
	"Treasure",
	"Milestone",
	"Mail",
	"Mail1",
	"Mail2",
    "Mug",
	"Teleport",
	"Transport",
	"Crystal01",
	"Crystal02",
	"Crystal03",
}
--------------------------------------------------------------------------------
AoMapResources.Localization = {
	[ "rus" ] = { -- Russian, Win-1251
		[ "Boss" ] = "",
		[ "Treasure" ] = "",
		[ "Milestone" ] = " ",
		[ "Mail" ] = "",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "",
		[ "Teleport" ] = "",
		[ "Transport" ] = "",
		[ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
	[ "eng" ] = { -- English, Latin-1
		[ "Boss" ] = "Boss",
		[ "Treasure" ] = "Treasure",
		[ "Milestone" ] = "Milestone",
		[ "Mail" ] = "Mail",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "Rest",
		[ "Teleport" ] = "Portal",
		[ "Transport" ] = "Ship",
		[ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
	[ "ger" ] = { -- German, Win-1252
		[ "Boss" ] = "Boss",
		[ "Treasure" ] = "Schatz",
		[ "Milestone" ] = "Meilenstein",
		[ "Mail" ] = "Post",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "Ruhe",
		[ "Teleport" ] = "Portal",
		[ "Transport" ] = "Schiff",
        [ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
	[ "fra" ] = { -- French, Win-1252
		[ "Boss" ] = "Boss",
		[ "Treasure" ] = "Trsor",
		[ "Milestone" ] = "Borne",
		[ "Mail" ] = "Courrier",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "Repos",
		[ "Teleport" ] = "Portail",
		[ "Transport" ] = "Navire",
        [ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
	[ "br" ] = { -- Portuguese, Win-1252
		[ "Boss" ] = "Boss",
		[ "Treasure" ] = "Tesouro",
		[ "Milestone" ] = "Marco milirio",
		[ "Mail" ] = "Correio",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "Descanso",
		[ "Teleport" ] = "Portal",
		[ "Transport" ] = "Navio",
        [ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
	[ "jpn" ] = { -- Japanese, Shift-JIS
		[ "Boss" ] = "{X",
		[ "Treasure" ] = "",
		[ "Milestone" ] = "}CXg[",
		[ "Mail" ] = "[",
		[ "Mail1" ] = " ",
		[ "Mail2" ] = " ",
		[ "Mug" ] = "Xg",
		[ "Teleport" ] = "|[^",
		[ "Transport" ] = "D",
        [ "Crystal01" ] = " ",
		[ "Crystal02" ] = " ",
		[ "Crystal03" ] = " ",
	},
}
--------------------------------------------------------------------------------
-- FUNCTIONS
--------------------------------------------------------------------------------
function AoMapResources:InstanceMapFound( fForced, strZone, strSubzone )
	if not strZone or not strSubzone then return end
	local Z = self:UncompressIMZone( self.InstanceMaps[ strZone ] )
	local IM = Z and ( Z[ strSubzone ] or Z[ "Default" ] )
	return IM and ( not fForced or fForced and IM.Forced ) and true or false
end
--------------------------------------------------------------------------------
function AoMapResources:GetInstanceMap( strZone, strSubzone )
	if not strZone or not strSubzone then return end
	local Z = self:UncompressIMZone( self.InstanceMaps[ strZone ] )
	return Z and ( Z[ strSubzone ] or Z[ "Default" ] )
end
--------------------------------------------------------------------------------
function AoMapResources:GetKnownObjects( strZone, Geodata )
	if not strZone or not Geodata then return {} end
	local Z = self:UncompressKOZone( self.KnownObjects[ strZone ] )
	if not Z then return end
	-- Also fixing positions
	for _,Object in Z do
		if not Object.Pos then
			Object.Pos = {}
			Object.Pos.posX = Geodata.x + Geodata.width * ( Object.SimplePos[ 1 ] / 100 )
			Object.Pos.posY = Geodata.y + Geodata.height * ( 1 - Object.SimplePos[ 2 ] / 100 )
			Object.SimplePos = nil
		end
	end
	return Z
end
--------------------------------------------------------------------------------
function AoMapResources:PurgeUselessResources()
	if not avatar.IsExist() then return end
	-- We need only one localization
	self.Locale = self.Localization[ GetGameLocalization() ] or self.Localization[ "eng" ]
	self.Localization = nil
	-- We don't need the Opposite Faction resources
	local OF = { [ "League" ] = "Empire", [ "Empire" ] = "League" }
	local strOppositeFactionFull = OF[ unit.GetFaction( avatar.GetId() ).sysName ]
	local strOppositeFaction = string.sub( strOppositeFactionFull, 1, 1 )
	for Zone in self.KnownObjects do
		if string.find( Zone, strOppositeFactionFull ) then
			self.KnownObjects[ Zone ] = nil
		else
			local fAltered = false
			local objects = self:UncompressKOZone( self.KnownObjects[ Zone ] )
			for i,v in objects do
				if v.Faction then
					if v.Faction == strOppositeFaction then
						objects[ i ] = nil
					else
						objects[ i ].Faction = nil
					end
					fAltered = true
				end
			end
			if fAltered then
				self.KnownObjects[ Zone ] = self:CompressKOZone( objects )
			end
		end
	end
	self.PurgeUselessResources = nil
	self.CompressIMZone = nil
	self.CompressKOZone = nil
	collectgarbage()
end
--------------------------------------------------------------------------------
function AoMapResources:L( strLine )
	if not strLine then return end
	return userMods.ToWString( self.Locale[ strLine ] or strLine )
end
--------------------------------------------------------------------------------
function AoMapResources:CompressIMZone( UncompressedInst )
	local CompressedInst = {}
	local iCount = 0
	for i,v in UncompressedInst do
		local CompressedSub = {}
		table.insert( CompressedSub, v.Geodata.x ) -- [1]
		table.insert( CompressedSub, v.Geodata.y ) -- [2]
		table.insert( CompressedSub, v.Geodata.width ) -- [3]
		table.insert( CompressedSub, v.Geodata.height ) -- [4]
		if v.Forced or v.Texture then
			table.insert( CompressedSub, v.Forced and true or false ) -- [5]
		end
		if v.Texture then
			table.insert( CompressedSub, v.Texture.name ) -- [6]
			table.insert( CompressedSub, v.Texture.ratio ) -- [7]
		end
		CompressedInst[ i ] = CompressedSub
		iCount = iCount + 1
	end
	return iCount > 0 and CompressedInst or nil
end
--------------------------------------------------------------------------------
function AoMapResources:UncompressIMZone( CompressedInst )
	if not CompressedInst then return nil end
	local UncompressedInst = {}
	for i,v in CompressedInst do
		local UncompressedSub = {}
		UncompressedSub.Geodata = { x = v[1], y = v[2], width = v[3], height = v[4] }
		UncompressedSub.Forced = v[5]
		if v[6] and v[7] then
			UncompressedSub.Texture = { name = v[6], ratio = v[7] }
		else
			UncompressedSub.Texture = { name = "_Unknown", ratio = 1 }
		end
		UncompressedInst[ i ] = UncompressedSub
	end
	return UncompressedInst
end
--------------------------------------------------------------------------------
function AoMapResources:CompressKOZone( UncompressedZone )
	local CompressedZone = {}
	for i,v in UncompressedZone do
		local CompressedObj = {}
		table.insert( CompressedObj, self.ObjectTypesEnum[ v.Type ] ) -- [1]
		if v.Pos then
			table.insert( CompressedObj, true ) -- [2]
			table.insert( CompressedObj, v.Pos.posX ) -- [3]
			table.insert( CompressedObj, v.Pos.posY ) -- [4]
		else
			table.insert( CompressedObj, false ) -- [2]
			table.insert( CompressedObj, v.SimplePos[1] ) -- [3]
			table.insert( CompressedObj, v.SimplePos[2] ) -- [4]
		end
		if v.Desc or v.Faction then
			table.insert( CompressedObj, v.Desc or false ) -- [5]
		end
		if v.Faction then
			table.insert( CompressedObj, v.Faction ) -- [6]
		end
		table.insert( CompressedZone, CompressedObj )
	end
	return table.getn( CompressedZone ) > 0 and CompressedZone or nil
end
--------------------------------------------------------------------------------
function AoMapResources:UncompressKOZone( CompressedZone )
	if not CompressedZone then return nil end
	local UncompressedZone = {}
	for i,v in CompressedZone do
		local UncompressedObj = {}
		UncompressedObj.Type = self.ObjectTypesList[ v[1] ]
		if v[2] then
			UncompressedObj.Pos = { posX = v[3], posY = v[4] }
		else
			UncompressedObj.SimplePos = { v[3], v[4] }
		end
		if v[5] then
			UncompressedObj.Desc = v[5]
		end
		if v[6] then
			UncompressedObj.Faction = v[6]
		end
		table.insert( UncompressedZone, UncompressedObj )
	end
	return UncompressedZone
end
--------------------------------------------------------------------------------
function AoMapResources:GetTableSize( t )
	local c = 0
	for _ in t do c = c + 1 end
	return c
end
--------------------------------------------------------------------------------
function AoMapResources:NonNumericValues( t )
	for _,v in t do
		if type( v ) ~= "number" then return true end
	end
end
--------------------------------------------------------------------------------
function AoMapResources:CheckFormat( iSupportedFormat )
	iSupportedFormat = math.floor( iSupportedFormat )
	if self.Format < iSupportedFormat or self.Format >= iSupportedFormat + 1 then
		self.InstanceMaps = {}
		self.KnownObjects = {}
		collectgarbage()
		local Fail = string.format( " (expected %d.XX, got %.2f). ", iSupportedFormat, self.Format )
		common.LogWarning( common.GetAddonName(), "Resources format mismatch"..Fail.."Please update MinimapSla addon." )
	end
	self.CheckFormat = nil
end
--------------------------------------------------------------------------------
function AoMapResources:SelfCheck()
	self.Warnings = 0
	-- Checking InstanceMaps
	for Zone,subzones in self.InstanceMaps do
		for i,v in subzones do
			local strItem = "AoMapResources.InstanceMaps[ \""..Zone.."\" ][ \""..i.."\" ]."
			local strWarning = nil
			if not strWarning then
				if not v.Geodata or type( v.Geodata ) ~= "table" then
					strWarning = strItem.."Geodata is not defined, or is not table!"
				elseif not v.Geodata.x or not v.Geodata.y or not v.Geodata.width or not v.Geodata.height then
					strWarning = strItem.."Geodata must be { x, y, width, height }!"
				elseif self:GetTableSize( v.Geodata ) ~= 4 then
					strWarning = strItem.."Geodata contains extra variables! (comma as decimal separator?)"
				elseif self:NonNumericValues( v.Geodata ) then
					strWarning = strItem.."Geodata contains non-numeric values!"
				end
			end
			if not strWarning then
				if v.Texture then
					if type( v.Texture ) ~= "table" or not v.Texture.name or not v.Texture.ratio then
						strWarning = strItem.."Texture (optional) must be { name, ratio }!"
					elseif self:GetTableSize( v.Texture ) ~= 2 then
						strWarning = strItem.."Texture contains extra variables! (comma as decimal separator?)"
					elseif type( v.Texture.name ) ~= "string" or v.Texture.name == "" then
						strWarning = strItem.."Texture.name is not string, or is empty string!"
					elseif not common.GetAddonRelatedTexture( v.Texture.name ) then
						strWarning = strItem.."Texture.name is not registered in UIRelatedTextures!"
					elseif type( v.Texture.ratio ) ~= "number" or v.Texture.ratio > 1 or v.Texture.ratio < 0 then
						strWarning = strItem.."Texture.ratio is bad number (must be 0.0-1.0)!"
					end
				end
			end
			if strWarning then
				self.Warnings = self.Warnings + 1
				common.LogWarning( common.GetAddonName(), strWarning )
				self.InstanceMaps[ Zone ][ i ] = nil
			end
		end
		if self:GetTableSize( self.InstanceMaps[ Zone ] ) == 0 then
			self.InstanceMaps[ Zone ] = nil
		end
	end
	-- Checking Icons
	for i,v in self.ObjectTypesEnum do
		if not common.GetAddonRelatedTexture( i ) then
			local strWarning = "AoMapResources.ObjectTypesList - Type (\""..i.."\") have no icon!"
			self.Warnings = self.Warnings + 1
			common.LogWarning( common.GetAddonName(), strWarning )
			self.ObjectTypesEnum[ i ] = nil
			self.ObjectTypesList[ v ] = nil
		end
	end
	-- Checking KnownObjects
	for Zone,objects in self.KnownObjects do
		for i,v in objects do
			local strItem = "AoMapResources.KnownObjects[ \""..Zone.."\" ][ "..i.." ]."
			local strWarning = nil
			if not strWarning then
				if not v.Type or type( v.Type ) ~= "string" or v.Type == "" then
					strWarning = strItem.."Type is not defined, or is not string, or is empty string!"
				elseif not self.ObjectTypesEnum[ v.Type ] then
					strWarning = strItem.."Type is not listed in ObjectTypesList!"
				end
			end
			if not strWarning then
				if not v.Pos and not v.SimplePos then
					strWarning = strItem.."Pos and .SimplePos both undefined!"
				end
			end
			if not strWarning then
				if v.Pos then
					if type( v.Pos ) ~= "table" then
						strWarning = strItem.."Pos is not table!"
					elseif not v.Pos.posX or not v.Pos.posY then
						strWarning = strItem.."Pos must be { posX = number, posY = number }!"
					elseif self:GetTableSize( v.Pos ) ~= 2 then
						strWarning = strItem.."Pos contains extra variables! (comma as decimal separator?)"
					elseif self:NonNumericValues( v.Pos ) then
						strWarning = strItem.."Pos contains non-numeric values!"
					end
				end
			end
			if not strWarning then
				if v.SimplePos then
					if type( v.SimplePos ) ~= "table" then
						strWarning = strItem.."SimplePos is not table!"
					elseif not v.SimplePos[1] or not v.SimplePos[2] then
						strWarning = strItem.."SimplePos must be { number, number }!"
					elseif self:GetTableSize( v.SimplePos ) ~= 2 then
						strWarning = strItem.."SimplePos contains extra variables! (comma as decimal separator?)"
					elseif self:NonNumericValues( v.SimplePos ) then
						strWarning = strItem.."SimplePos contains non-numeric values!"
					elseif v.SimplePos[1]<0 or v.SimplePos[1]>100 or v.SimplePos[2]<0 or v.SimplePos[2]>100 then
						strWarning = strItem.."SimplePos contains bad numbers (must be 0-100)!"
					end
				end
			end
			if not strWarning then
				if v.Faction then
					if type( v.Faction ) ~= "string" or ( v.Faction ~= "L" and v.Faction ~= "E" ) then
						strWarning = strItem.."Faction (optional) declared, but it is wrong (must be \"L\" or \"E\")!"
					end
				end
			end
			if not strWarning then
				if v.Desc then
					if type( v.Desc ) ~= "string" or v.Desc == "" then
						strWarning = strItem.."Desc (optional) declared, but it is not string, or is empty string!"
					end
				end
			end
			if strWarning then
				self.Warnings = self.Warnings + 1
				common.LogWarning( common.GetAddonName(), strWarning )
				self.KnownObjects[ Zone ][ i ] = nil
			end
		end
	end
	if self.Warnings > 0 then
		common.LogInfo( common.GetAddonName(), "AoMapResources loaded with "..self.Warnings.." warnings." )
	end
end
--------------------------------------------------------------------------------
-- AO game Localization detection by SLA. Version 2011-02-10.
function GetGameLocalization()
	local B = cartographer.GetMapBlocks()
	local T = { rus="\203\232\227\224", eng="Holy Land", ger="Heiliges Land",
	fra="Terre Sacr\233e", br="Terra Sagrada", jpn="\131\74\131\106\131\65" }
	for b in B do for l,t in T do
	if userMods.FromWString( cartographer.GetMapBlockInfo(B[b]).name ) == t
	then return l end end end return "eng"
end
--------------------------------------------------------------------------------
-- INITIALIZATION
--------------------------------------------------------------------------------
function AoMapResources:Init()
	-- Object types Enum
	self.ObjectTypesEnum = {}
	for i,v in self.ObjectTypesList do
		self.ObjectTypesEnum[ v ] = i
	end
	-- Default locale
	self.Locale = self.Localization[ "eng" ]
	-- Database Self-Check
	self:SelfCheck()
	-- Compressing Database
	for i,v in self.InstanceMaps do
		self.InstanceMaps[ i ] = self:CompressIMZone( v )
	end
	for i,v in self.KnownObjects do
		self.KnownObjects[ i ] = self:CompressKOZone( v )
	end
	-- Freeing some memory
	self.GetTableSize = nil
	self.NonNumericValues = nil
	self.SelfCheck = nil
	self.Init = nil
	collectgarbage()
end
--------------------------------------------------------------------------------
AoMapResources:Init()
--------------------------------------------------------------------------------
