-- MapDrawing by SLA
-- Created: 2011-01-19
-- Updated: 2011-02-10
-- http://ui9.ru/

-- This file helps to create Instance Maps for "Allods Online",
-- And to collect the coordinates of important objects.
-- If you don't know what is it for, or how it works, read the guide:
-- http://ui9.ru/forum/minimapsla

--------------------------------------------------------------------------------
-- GLOBALS
--------------------------------------------------------------------------------
Global( "MapDrawing", {
	Events = {}
} )
--------------------------------------------------------------------------------
-- EVENT HANDLERS
--------------------------------------------------------------------------------
-- AoMapGenerator helper
MapDrawing.Events[ "EVENT_USER_SCREENSHOT" ] = function( params )
	if not avatar.IsExist() then return end
	-- Collecting data
	local z = cartographer.GetCurrentZone()
	local zmi = cartographer.GetZonesMapInfo( z.zonesMapId )
	local strSysZoneName = ( not zmi.isUnknown and zmi.isShowPositions ) and zmi.sysName or z.sysZoneName
	local p = object.GetPos( avatar.GetId() )
	local d = avatar.GetDir()
	local c = mission.GetCameraDirection()
	local strScreen = userMods.FromWString( params.fileName )
	local Target = unit.GetPrimaryTarget( avatar.GetId() )
	local Interactor = avatar.GetInteractorInfo()
	local t, i
	if Target and Target == Interactor.interactorId then
		Target = nil
	end
	if Target or Interactor then
		local DetectedObjects = avatar.GetDetectedObjects()
		for _,ID in DetectedObjects do
			if Target and Target == ID then
				t = object.GetPos( ID )
			end
			if Interactor and Interactor.interactorId == ID then
				i = object.GetPos( ID )
			end
		end
	end
	local strNameT = t and userMods.FromWString( object.GetName( Target ) ) or ""
	local strNameI = i and userMods.FromWString( object.GetName( Interactor.interactorId ) ) or ""
	strNameT = string.gsub( strNameT, "^%s*(.-)%s*$", "%1" ) -- Strip whitespace
	strNameI = string.gsub( strNameI, "^%s*(.-)%s*$", "%1" ) -- Strip whitespace
	local Geodata = cartographer.GetObjectGeodata( avatar.GetId(), z.zonesMapId ) -- nil in Instance
	-- Logging data for MAP building
	if Config.MapDrawing then
		local strTarget = t and string.format( "|t|%s|%.3f|%.3f|%.3f", strNameT, t.posX, t.posY, t.posZ ) or ""
		local strInteractor = i and string.format( "|i|%s|%.3f|%.3f|%.3f", strNameI, i.posX, i.posY, i.posZ ) or ""
		if z and p and d and c then
			local strLog = string.format( "Screenshot|%s|%s|%s|%.3f|%.3f|%.3f|%.3f|%.3f%s%s",
				strScreen, strSysZoneName, z.sysSubZoneName, p.posX, p.posY, p.posZ, d, c, strTarget, strInteractor )
			common.LogInfo( common.GetAddonName(), strLog )
		end
	end
	-- Logging data for RESOURCE collecting
	if Config.ResourceCollecting then
		MapDrawing:LogObject( "You: ", nil, p, Geodata, strSysZoneName, strScreen )
		MapDrawing:LogObject( "TARGET: ", strNameT, t, Geodata, strSysZoneName, strScreen )
		MapDrawing:LogObject( "INTERACTOR: ", strNameI, i, Geodata, strSysZoneName, strScreen )
	end
end
--------------------------------------------------------------------------------
function MapDrawing:LogObject( strPrefix, strName, Pos, Geodata, strZone, strScreen )
	if not Pos then return end
	local strName = strName and ( "\"" .. strName .. "\" @ " ) or ""
	local strSimplePos = ""
	if Geodata then
		local SimplePosX = ( Pos.posX - Geodata.x ) / Geodata.width * 100
		local SimplePosY = 100 - ( Pos.posY - Geodata.y ) / Geodata.height * 100
		strSimplePos = string.format( "%.2f:%.2f ", SimplePosX, SimplePosY )
	end
	local strLog = string.format( "%s{ Type = \"\", Pos = { posX = %.3f, posY = %.3f } }, -- %s%s%s -- %s",
		strPrefix, Pos.posX, Pos.posY, strSimplePos, strName, strZone, strScreen )
	common.LogInfo( common.GetAddonName(), strLog )
end
--------------------------------------------------------------------------------
-- INITIALIZATION
--------------------------------------------------------------------------------
function MapDrawing:Init()
	-- Events
	if Config.MapDrawing or Config.ResourceCollecting then
		for name, handler in MapDrawing.Events do
			common.RegisterEventHandler( handler, name )
		end
	else
		MapDrawing = nil
	end
end
--------------------------------------------------------------------------------
MapDrawing:Init()
--------------------------------------------------------------------------------
