---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "onEvent", {} )
Global( "onReaction", {} )
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "ShowHideBtn", nil )
Global( "MainPanel", nil )
Global( "SpellsPanel", nil )
Global( "FightPanel", nil )
---------------------------------------------------------------------------------------------------------------------------
Global( "PlayerPanelList", {} )
Global( "SpellPanelList", {} )
Global( "SpellInfoPanelList", {} )
Global( "SpellBlockPanelList", {} )
---------------------------------------------------------------------------------------------------------------------------
Global( "DPSMeter", {} )
Global( "ActiveFightID" , nil )
Global( "SelectedCombatantName" , "" )
Global( "SelectedPlayerPanelID" , nil )
Global( "MAXCOMBATANTS", 24 )
Global( "MAXSPELLS", 12 )
Global( "DMGTYPES", 5 )
Global( "BLOCKDMGTYPES", 5 )
Global( "HEAVYMODE_MAXCOMBATANTS", 6 )
Global( "CLEANUP_DELAY", 2 )
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function HideAllPlayerPanel()
	for i = 1, MAXCOMBATANTS do
		PlayerPanelList[ i ]:Hide()
	end
end
--------------------------------------------------------------------------------
function SetValuesToPlayerPanel( index, Fight )
	local PlayerPanel = PlayerPanelList[ index ]
	local Combatant = Fight:GetCombatantByIndex( index )
	if not Combatant then return end
	
	PlayerPanel:Show()
	
	local Bar = PlayerPanel:GetChildByName( "PlayerInfoBar" )
	local NameTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewName" )
	local StatsTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewStats" )
	local PercentageTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewPercentage" )
	
	Bar:SetWidth( 230 * ( Combatant.LeaderPercentage / 100 ) )
	NameTextView.Widget:SetVal( "Index", common.FormatInt( index , "%d" ) )
	NameTextView.Widget:SetVal( "Name", Combatant.Name )
	StatsTextView.Widget:SetVal( "DamageDone", common.FormatFloat( Combatant.DamageAmount, "%f3K5" ) )
	StatsTextView.Widget:SetVal( "DPS", common.FormatFloat( Combatant.DPS, "%f3K5" ) )
	PercentageTextView.Widget:SetVal( "Percentage", common.FormatInt( Combatant.DamagePercentage, "%d" ) )
	
	--if Combatant.bCanUpdate then
		Bar:SetColor( ClassColors[ Combatant.Class ] )
	--else
	--	Bar:SetColor( ClassColors[ Combatant.Class ], 0.5 )
	--end
end
--------------------------------------------------------------------------------
function SetDPSMeterValues()
	if not MainPanel.Widget:IsVisible() then return end
	
	local Fight = DPSMeter:GetFight( ActiveFightID )
	
	Fight:RecalculateCombatantsData() -- Important
	
	local CombatantCount = math.min( Fight:GetCombatantCount(), MAXCOMBATANTS )
	
	HideAllPlayerPanel()
	MainPanel:SetHeight( 47 + CombatantCount * 24 )
	
	for i = 1, CombatantCount do
		SetValuesToPlayerPanel( i, Fight )
	end
end
---------------------------------------------------------------------------------------------------------------------------
function SetSpellValuesToSpellPanel( CombatantData, index )
	
	local SpellData = CombatantData:GetSpellByIndex( index )
	local SpellPanel = SpellPanelList[ index ]
	
	if SpellData then
		
		SpellPanel:Show()
		
		local Bar = SpellPanel:GetChildByName( "SpellBar" )
		local TextViewName = SpellPanel:GetChildByName( "SpellTextViewName" )
		local TextViewDamage = SpellPanel:GetChildByName( "SpellTextViewStats" )
		local TextViewPercentage = SpellPanel:GetChildByName( "SpellTextViewPercentage" )
		
		Bar:SetColor( DamageTypeColors[ SpellData.DamageType ] )
		Bar:SetWidth( 356 * ( SpellData.DamagePercentage / 100 ) )
		
		TextViewName.Widget:SetVal( "Index", common.FormatInt( index , "%d" ) )
		TextViewName.Widget:SetVal( "Name", SpellData.Name )
		TextViewDamage.Widget:SetVal( "DamageDone", common.FormatFloat( SpellData.DamageAmount , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "DPS", common.FormatFloat( SpellData.DPS , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "DamageBlock", common.FormatFloat( SpellData.BlockDmgPercentage , "%d" ) )
		TextViewPercentage.Widget:SetVal( "Percentage", common.FormatInt( SpellData.DamagePercentage , "%d" ) )
		
	end
end
--------------------------------------------------------------------------------
function SetDamageDetails()
	if not SpellsPanel.Widget:IsVisible() then return end
	
	local SelectedFight = DPSMeter:GetFight( ActiveFightID )
	local SelectedCombatantData = SelectedFight:GetCombatantByName( SelectedCombatantName )
	
	SpellsPanel:HideAllChild()
	local CloseSpellsPanelBtn = SpellsPanel:GetChildByName( "CloseBtn" )
	local TextViewName = SpellsPanel:GetChildByName( "SpellPlayerNameTextViewName" )
	CloseSpellsPanelBtn:Show()
	
	if ( SelectedCombatantData ) then
		
		SelectedCombatantData:CalculateSpellDamage( SelectedFight.FightTime ) -- Important.
		
		TextViewName.Widget:SetVal( "Name", SelectedCombatantData.Name )
		TextViewName:Show()
		if SelectedCombatantData.DamageAmount ~= 0 then
			SpellsPanel:GetChildByName( "SpellHeaderPanel" ):Show()
		end
		for i = 1, MAXSPELLS do
			SetSpellValuesToSpellPanel( SelectedCombatantData, i )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_CHANGED" ] = function( params )
	if group.GetMembers() or raid.IsExist() then
		
		local PartyMembersInfoList = DPSMeter:GetPartyMembers()
		
		for i, member in PartyMembersInfoList do
			if not DPSMeter:GetFight( DPSMeter.Fight.Current ):GetCombatantByName( member.name ) then
				DPSMeter:AddNewCombatantByName( member.name )
			end
			for _, FightID in DPSMeter.Fight do
				DPSMeter:GetFight( FightID ):GetCombatantByName( member.name ):UpdateCombatantDataByID( member.id )
			end
			if member.state == GROUP_MEMBER_STATE_NEAR then
				DPSMeter:SetCombatantUpdateStatusByName(member.name, true)
			else
				DPSMeter:SetCombatantUpdateStatusByName(member.name, false)
			end
		end
		
		if raid.IsExist() then
			for i, Combatant in DPSMeter:GetCurrentCombatants() do
				local bInvalid = true
				if IsThisStringValue ( Combatant.Name, object.GetName( avatar.GetId() ) ) then
					bInvalid = false
				else
					for j, member in PartyMembersInfoList do
						if IsThisStringValue ( Combatant.Name, member.name) then
							bInvalid = false
						end
					end
				end
				if bInvalid then
					DPSMeter:RemoveCombatantByName( Combatant.Name )
				end
			end
		end
		
	end
	SetDPSMeterValues()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_CHANGED" ] =
	onEvent[ "EVENT_GROUP_CHANGED" ]
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_MEMBER_STATUS_CHANGED" ] = function( params )
	if group.GetLeaderIndex() ~= -1 then
		local PartyMembersInfoList = DPSMeter:GetPartyMembers()
		for i, member in PartyMembersInfoList do
			for _, FightID in DPSMeter.Fight do
				local Combatant = DPSMeter:GetFight( FightID ):GetCombatantByName( member.name )
				if Combatant then -- and not Combatant.ID then -- Raid members' IDs probably changes after they re-login.
					Combatant:UpdateCombatantDataByID( member.id )
				end
			end
			if member.state == GROUP_MEMBER_STATE_NEAR then
				DPSMeter:SetCombatantUpdateStatusByName( member.name, true )
			else
				DPSMeter:SetCombatantUpdateStatusByName( member.name, false )
			end
		end
	end
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_MEMBER_STATUS_CHANGED" ] =
	onEvent[ "EVENT_RAID_MEMBER_STATUS_CHANGED" ]
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_DISAPPEARED" ] = function( params )
	DPSMeter:ResetAllFights()
	
	DPSMeter:AddNewCombatant( avatar.GetId() )
	SelectedCombatantName = object.GetName( avatar.GetId() )
	SetDPSMeterValues()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_DISAPPEARED" ] =
	onEvent[ "EVENT_GROUP_DISAPPEARED" ]
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_MEMBER_REMOVED" ] = function( params )
	DPSMeter:RemoveCombatantByName( params.name )
	SetDPSMeterValues()
end
---------------------------------------------------------------------------------------------------------------------------
onEvent[ "EVENT_SECOND_TIMER" ] = function( params )
	if not avatar.IsExist() then return end
	
	onEvent[ "EVENT_RAID_MEMBER_STATUS_CHANGED" ]() -- Do we still need it here?
	
	if ( DPSMeter.bCollectData ) then
		
		if not DPSMeter:IsCombatantsInCombat() and not DPSMeter:IsEnemiesInCombat() then
			DPSMeter:Stop()
		end
		
		DPSMeter:UpdateFightsTime()
		
		SetDPSMeterValues()
		SetDamageDetails()
		
	elseif ( DPSMeter.OffBattleTime ) then
		
		if ( DPSMeter.OffBattleTime >= CLEANUP_DELAY ) then
			DPSMeter:CleanupOpponents()
		else
			DPSMeter.OffBattleTime = DPSMeter.OffBattleTime + 1
		end
		
	end
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_UNIT_DAMAGE_RECEIVED" ] = function( params )
	if not params then return end
	
	DPSMeter:CollectCombatantsData( params )
	
	if DPSMeter:GetFight( DPSMeter.Fight.Current ):GetCombatantCount() <= HEAVYMODE_MAXCOMBATANTS then
		SetDPSMeterValues()
		SetDamageDetails()
	end
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_AVATAR_CREATED" ] = function( params )
	-- Since AO 2.0.03, localization must be applied here
	localization = GetGameLocalization()
	if not common.GetAddonRelatedTextGroup( localization ) then
		localization = "eng"
	end
	onEvent[ "SCRIPT_ADDON_INFO_REQUEST" ]( { target = common.GetAddonName() } )
	
	strPet = userMods.FromWString( GetTextLocalized( "Pet" ) )
	FightPanel:GetChildByName( "FightNameTextView" ).Widget:SetVal( "Name", GetTextLocalized( "CurrentFight" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellHeaderTextViewName",  true ):SetVal( "Name", GetTextLocalized( "Ability" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellHeaderTextViewStats", true ):SetVal( "DamageDone", GetTextLocalized( "Damage" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellHeaderTextViewStats", true ):SetVal( "DPS", GetTextLocalized( "DPS" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewName",  true ):SetVal( "Name", GetTextLocalized( "Type" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Min",  GetTextLocalized( "Min" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Avg",  GetTextLocalized( "Avg" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Max",  GetTextLocalized( "Max" ) )
	
	DPSMeter:AddNewCombatant( avatar.GetId() )
	SelectedCombatantName = object.GetName( avatar.GetId() )
	SetDPSMeterValues()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_ADDON_INFO_REQUEST" ] = function( params )
	if params.target == common.GetAddonName() then
		userMods.SendEvent( "SCRIPT_ADDON_INFO_RESPONSE", {
			sender = params.target,
			desc = userMods.FromWString( GetTextLocalized( "Description" ) ),
			showDNDButton = true,
			showHideButton = true,
			showSettingsButton = true,
		} )
	end
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_ADDON_MEM_REQUEST" ] = function( params )
	if params.target == common.GetAddonName() then
		userMods.SendEvent( "SCRIPT_ADDON_MEM_RESPONSE", { sender = params.target, memUsage = gcinfo() } )
	end
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_SHOW_SETTINGS" ] = function( params )
	if not MainPanel.Widget:IsVisible() then
		onReaction[ "ShowHideBtnReaction" ]()
	end
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_TOGGLE_VISIBILITY" ] = function( params )
	if params.target == common.GetAddonName() then
		if params.state then
			ShowHideBtn:Show()
		else
			ShowHideBtn:Hide()
		end
	end
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_TOGGLE_DND" ] = function( params )
	if params.target == common.GetAddonName() then
		ShowHideBtn:DragNDrop( params.state )
	end
end
--------------------------------------------------------------------------------
onEvent[ "SCRIPT_TOGGLE_UI" ] = function( params )
	mainForm:Show( params.visible )
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function SetSpellInfoValuesToSpellInfoPanel( SpellData, index )
	
	local SpellInfoData = SpellData.DamageDetailsList[ index ]
	local SpellInfoPanel = SpellInfoPanelList[ index ]
	
	if (SpellInfoData) and ( SpellInfoData.Count > 0 ) then
		
		SpellInfoPanel:Show()
		
		local Bar = SpellInfoPanel:GetChildByName( "SpellDetailBar" )
		local TextViewName = SpellInfoPanel:GetChildByName( "SpellDetailTextViewName" )
		local TextViewCount = SpellInfoPanel:GetChildByName( "SpellDetailTextViewCount" )
		local TextViewDamage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewStats" )
		local TextViewPercentage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewPercentage" )
		
		Bar:SetColor( HitTypeColors[ SpellInfoData.ID ] )
		Bar:SetWidth( 356 * ( SpellInfoData.Percentage / 100 ) )
		
		local Title = { "Normal", "Critical", "Glancing", "Dodge", "Miss" }
		
		TextViewName.Widget:SetVal( "Name", GetTextLocalized( Title[ SpellInfoData.ID ] ) )
		TextViewCount.Widget:SetVal( "Count", common.FormatInt( SpellInfoData.Count , "%d" ) )
		TextViewDamage.Widget:SetVal( "Min", common.FormatFloat( SpellInfoData.Min , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Avg", common.FormatFloat( SpellInfoData.Avg , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Max", common.FormatFloat( SpellInfoData.Max , "%f3K5" ) )
		TextViewPercentage.Widget:SetVal( "Percentage", common.FormatInt( SpellInfoData.Percentage , "%d" ) )
		
	end
end
--------------------------------------------------------------------------------
function SetSpellInfoBlockDmgValuesToSpellInfoPanel( SpellData, index )
	
	local SpellInfoData = SpellData.BlockDmgDetailsList[ index ]
	local SpellInfoPanel = SpellBlockPanelList[ index ]
	
	if (SpellInfoData) and ( SpellInfoData.Count > 0 ) then
		
		SpellInfoPanel:Show()
		
		local Bar = SpellInfoPanel:GetChildByName( "SpellDetailBar" )
		local TextViewName = SpellInfoPanel:GetChildByName( "SpellDetailTextViewName" )
		local TextViewCount = SpellInfoPanel:GetChildByName( "SpellDetailTextViewCount" )
		local TextViewDamage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewStats" )
		local TextViewPercentage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewPercentage" )
		
		Bar:SetColor( HitTypeColors[ SpellInfoData.ID ] )
		Bar:SetWidth( 356 * ( SpellInfoData.Percentage / 100 ) )
		
		local Title = { "Block", "Parry", "Barrier", "Resist", "Absorb" }
		
		TextViewName.Widget:SetVal( "Name", GetTextLocalized( Title[ SpellInfoData.ID ] ) )
		TextViewCount.Widget:SetVal( "Count", common.FormatInt( SpellInfoData.Count , "%d" ) )
		TextViewDamage.Widget:SetVal( "Min", common.FormatFloat( SpellInfoData.Min , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Avg", common.FormatFloat( SpellInfoData.Avg , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Max", common.FormatFloat( SpellInfoData.Max , "%f3K5" ) )
		TextViewPercentage.Widget:SetVal( "Percentage", common.FormatInt( SpellInfoData.Percentage , "%d" ) )
		
	end
end
--------------------------------------------------------------------------------
function HideAllSpellInfoPanel()
	for i = 1, DMGTYPES do
		SpellInfoPanelList[ i ]:Hide()
	end
	for i = 1, BLOCKDMGTYPES do
		SpellBlockPanelList[ i ]:Hide()
	end
end
--------------------------------------------------------------------------------
function GetSpellPanelIndex( reaction )
	--string.len( "SpellPanel" ) + 1 = 11
	return tonumber( string.sub( reaction.sender, 11 ) ) or -1
end
--------------------------------------------------------------------------------
function GetPlayerPanelIndex( reaction )
	--string.len( "PlayerPanel" ) + 1 = 12
	return tonumber( string.sub( reaction.sender, 12 ) ) or -1
end
---------------------------------------------------------------------------------------------------------------------------
onReaction[ "SpellPanelOnPointing" ] = function( reaction )
	
	HideAllSpellInfoPanel()
	local HeaderPanel = SpellsPanel:GetChildByName( "SpellDetailHeaderPanel" )
	
	if reaction.active then
		local SpellPanelIndex = GetSpellPanelIndex( reaction )
		local SelectedCombatantData = DPSMeter:GetFight( ActiveFightID ):GetCombatantByName( SelectedCombatantName )
		
		HeaderPanel:Show()
		
		if ( SelectedCombatantData ) then
			local SpellData = SelectedCombatantData:GetSpellByIndex( SpellPanelIndex )
			for i = 1, DMGTYPES do
				SetSpellInfoValuesToSpellInfoPanel( SpellData, i )
			end
			--
			for i = 1, BLOCKDMGTYPES do
				SetSpellInfoBlockDmgValuesToSpellInfoPanel( SpellData, i )
			end
		end
	else
		HeaderPanel:Hide()
	end
end
--------------------------------------------------------------------------------
onReaction[ "ResetBtnReaction" ] = function( reaction )
	onEvent["EVENT_GROUP_DISAPPEARED"]()
	onEvent["EVENT_GROUP_CHANGED"]()
end
--------------------------------------------------------------------------------
onReaction[ "CloseMainPanelBtnReaction" ] = function( reaction )
	MainPanel:Hide()
	SpellsPanel:Hide()
end
--------------------------------------------------------------------------------
onReaction[ "PlayerPanelOnPointing" ] = function( reaction )
	SelectedPlayerPanelID = reaction.active and GetPlayerPanelIndex( reaction ) or -1
end
--------------------------------------------------------------------------------
onReaction[ "PlayerInfoButtonDown" ] = function( reaction )
	SelectedCombatantName = DPSMeter:GetFight( ActiveFightID ):GetCombatantNameByIndex( SelectedPlayerPanelID )
	SpellsPanel:Show()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onReaction[ "CloseSpellInfoPanelBtnReaction" ] = function( reaction )
	SpellsPanel:Hide()
end
--------------------------------------------------------------------------------
onReaction[ "GetFightBtnReaction" ] = function( reaction )
	local invertMode = { [ DPSMeter.Fight.Total ] = DPSMeter.Fight.Current, [ DPSMeter.Fight.Current ] = DPSMeter.Fight.Total }
	ActiveFightID = invertMode[ ActiveFightID ]
	
	local Title = { [ DPSMeter.Fight.Current ] = "CurrentFight", [ DPSMeter.Fight.Total ] = "OverallData" }
	FightPanel:GetChildByName( "FightNameTextView" ).Widget:SetVal( "Name", GetTextLocalized( Title[ ActiveFightID ] ) )
	
	SetDPSMeterValues()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onReaction[ "ShowHideBtnReaction" ] = function( reaction )
	if DnD:IsDragging() then return end
	if MainPanel.Widget:IsVisible() then
		MainPanel:Hide()
		SpellsPanel:Hide()
	else
		MainPanel:Show()
		if avatar.IsExist() then
			SetDPSMeterValues()
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function Init()
	RegisterEventHandlers( onEvent )
	RegisterReactionHandlers( onReaction )
	
	---------------------------------------------------------------------------------------------------------------------------
	
	ShowHideBtn = TWidget:CreateNewObject( "ShowHideBtn" )
	ShowHideBtn:DragNDrop( true, 687, nil, true )
	
	MainPanel = TWidget:CreateNewObject( "MainPanel" )
	MainPanel:DragNDrop( true, 686, nil, true, false )
	
	SpellsPanel = TWidget:CreateNewObject( "SpellInfoPanel" )
	SpellsPanel:DragNDrop( true, 688, nil, true )
	
	FightPanel = MainPanel:GetChildByName( "FightPanel" )
	
	---------------------------------------------------------------------------------------------------------------------------
	
	local PlayerPanelDesc = MainPanel:GetChildByName( "PlayerInfoPanel" ):GetDesc()
	MainPanel:GetChildByName( "PlayerInfoPanel" ):Destroy()
	for i = 1, MAXCOMBATANTS do
		local wtName = "PlayerPanel" .. i
		PlayerPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, PlayerPanelDesc, MainPanel )
		PlayerPanelList[ i ]:SetPosition( 20, 47 + (i-1) * 24 )
	end
	
	local SpellPanelDesc = SpellsPanel:GetChildByName( "SpellPanel" ):GetDesc()
	SpellsPanel:GetChildByName( "SpellPanel" ):Destroy()
	for i = 1, MAXSPELLS do
		local wtName = "SpellPanel" .. i
		SpellPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, SpellPanelDesc, SpellsPanel )
		SpellPanelList[ i ]:SetPosition( 22, 54 + (i-1) * 18 )
	end
	
	local SpellInfoPanelDesc = SpellsPanel:GetChildByName( "SpellDetailPanel" ):GetDesc()
	SpellsPanel:GetChildByName( "SpellDetailPanel" ):Destroy()
	for i = 1, DMGTYPES do
		local wtName = "SpellInfoPanel" .. i
		SpellInfoPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, SpellInfoPanelDesc, SpellsPanel )
		SpellInfoPanelList[ i ]:SetPosition( 22, 305 + (i-1) * 18 )
	end
	--
	for i = 1, BLOCKDMGTYPES do
		local wtName = "SpellBlockPanel" .. i
		SpellBlockPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, SpellInfoPanelDesc, SpellsPanel )
		SpellBlockPanelList[ i ]:SetPosition( 22, 400 + (i-1) * 18 )
	end
	
	---------------------------------------------------------------------------------------------------------------------------
	
	DPSMeter = TDPSMeter:CreateNewObject()
	DPSMeter:ResetAllFights()
	
	ActiveFightID = DPSMeter.Fight.Current -- User-selected view.
	
	-- Backward compatibility with pre-1.1.04 versions:
	if not social.GetFriendInfo then
		mainForm:SetPriority( 1000 )
	end
	
	if avatar.IsExist() then
		onEvent["EVENT_AVATAR_CREATED"]()
		onEvent["EVENT_GROUP_CHANGED"]()
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Init()
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
